package injector.sample;

import injector.*;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

/**
* Auto generated server configuration for {@link injector.sample.ClientBImpl}.
*/
@ExposedAs( Job.class )
@javax.annotation.processing.Generated("injector.apt.MainloopMethodProcessor")
public class ClientBImplMainloopRunner0 implements Job {

    private static final ExecutorService BACKGROUND = Executors.newFixedThreadPool(1);
    private static boolean JOB_MAY_RUN = true;

    static {
        Runtime.getRuntime().addShutdownHook(new Thread() {
            public void run() {
                try {
                    JOB_MAY_RUN = false;
                    BACKGROUND.shutdown();
                    if (!BACKGROUND.awaitTermination(120, TimeUnit.SECONDS)) {
                        final List<Runnable> droppedTasks = BACKGROUND.shutdownNow();
                        System.err.println(
                            "Executor was abruptly shut down. " + droppedTasks.size() + " tasks will not be executed.");
                    }
                } catch (final InterruptedException cause) {
                    cause.printStackTrace();
                }
            }
        });
    }

    private final ClientBImpl instance;

    public ClientBImplMainloopRunner0( final ClientBImpl instance ){
        this.instance = instance;
    }

    public void execute() throws Exception {
        for ( int i=0; i<1; i++ ) {
            BACKGROUND.submit( new Runnable() {

                @Override
                public void run(){
                    try {
                        while( JOB_MAY_RUN ){
                            instance.runMultipleTimes();
                            Thread.sleep(1L);
                        }
                    } catch( final InterruptedException cause ) {
                    } catch( final Throwable cause ) {
                        System.err.println(
                            "Failed to execute ClientBImpl.runMultipleTimes in background. Aborted." );
                        cause.printStackTrace();
                    }
                }
            });
        }
    }
}
