/*
 * Decompiled with CFR 0.152.
 */
package injector;

import injector.DirectCyclicDependencyException;
import injector.ExposedServicesLoader;
import injector.Factory;
import injector.FirstStackOverflowOccurrence;
import injector.Job;
import injector.LazyExposedServiceLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Consumer;

public interface Injector {
    public <T> Factory<T> factoryOf(Class<T> var1);

    default public <T> T instanceOf(Class<T> clazz) {
        return this.instanceOf(clazz, null);
    }

    public <T> T instanceOf(Class<T> var1, Class var2);

    public <T> Injector registerFactoryOf(Class<T> var1, Factory<T> var2);

    public <T> Injector registerExposedServiceLoaderOf(Class<T> var1, ExposedServicesLoader<T> var2);

    public <T> Iterable<T> instancesExposedAs(Class<T> var1);

    public Injector setLogger(Consumer<String> var1);

    public static Injector create() {
        return Injector.create(true);
    }

    public static Injector create(boolean bl) {
        DefaultInjector defaultInjector = new DefaultInjector();
        if (bl) {
            Iterable<Job> iterable = defaultInjector.instancesExposedAs(Job.class);
            for (Job job : iterable) {
                try {
                    job.execute();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return defaultInjector;
    }

    public static class DefaultInjectorFactory
    implements Factory<Injector> {
        @Override
        public Injector create(Injector injector, Class clazz) {
            return injector;
        }

        @Override
        public Class<Injector> getExposedType() {
            return Injector.class;
        }
    }

    public static class DefaultInjector
    implements Injector {
        private final Map<Class, Factory> cache = new HashMap<Class, Factory>();
        private Map<Class, Iterable> exposed = new HashMap<Class, Iterable>();
        private boolean exposedClassesLoaded = false;
        Consumer<String> logger = new StdOutErrorPrinter();

        public DefaultInjector() {
            this.registerFactoryOf(Injector.class, new DefaultInjectorFactory());
            ServiceLoader<Factory> serviceLoader = ServiceLoader.load(Factory.class);
            for (Factory factory : serviceLoader) {
                this.registerFactoryOf(factory.getExposedType(), factory);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<Class, Iterable> getExposed() {
            if (!this.exposedClassesLoaded) {
                DefaultInjector defaultInjector = this;
                synchronized (defaultInjector) {
                    if (!this.exposedClassesLoaded) {
                        this.exposedClassesLoaded = true;
                        this.exposed.putAll(this.readExposedClasses());
                    }
                }
            }
            return this.exposed;
        }

        private Map<Class, Iterable> readExposedClasses() {
            HashMap<Class, Iterable> hashMap = new HashMap<Class, Iterable>();
            ServiceLoader<ExposedServicesLoader> serviceLoader = ServiceLoader.load(ExposedServicesLoader.class);
            for (ExposedServicesLoader exposedServicesLoader : serviceLoader) {
                this.registerExposedServiceLoaderOf(exposedServicesLoader.getExposedType(), exposedServicesLoader);
            }
            return hashMap;
        }

        @Override
        public <T> Factory<T> factoryOf(Class<T> clazz) {
            return this.cache.get(clazz);
        }

        @Override
        public <T> T instanceOf(Class<T> clazz, Class clazz2) {
            Factory<T> factory = this.factoryOf(clazz);
            if (factory != null) {
                return this.tryCreateInstanceOf(factory, clazz, clazz2);
            }
            String string = "No implementation available for " + clazz.getCanonicalName() + "\n This might be the case that the class exists but is not managed by Injector.\n Hint: try add @injector.Singleton or @injector.New in the class.\n";
            throw new IllegalArgumentException(string);
        }

        private <T> T tryCreateInstanceOf(Factory<T> factory, Class<T> clazz, Class clazz2) {
            try {
                return factory.create(this, clazz2);
            }
            catch (StackOverflowError stackOverflowError) {
                throw new FirstStackOverflowOccurrence(clazz);
            }
            catch (FirstStackOverflowOccurrence firstStackOverflowOccurrence) {
                throw new DirectCyclicDependencyException(clazz, firstStackOverflowOccurrence.currentTargetClass);
            }
        }

        @Override
        public <T> Injector registerExposedServiceLoaderOf(Class<T> clazz, ExposedServicesLoader<T> exposedServicesLoader) {
            LazyExposedServiceLoader<T> lazyExposedServiceLoader = new LazyExposedServiceLoader<T>(exposedServicesLoader, this);
            this.getExposed().put(exposedServicesLoader.getExposedType(), lazyExposedServiceLoader);
            return this;
        }

        @Override
        public <T> Injector registerFactoryOf(Class<T> clazz, Factory<T> factory) {
            Factory<T> factory2 = this.cache.put(clazz, factory);
            if (factory2 != null) {
                this.logger.accept("More than one Factory defined for " + clazz.getCanonicalName() + ". " + String.join((CharSequence)",", factory2.getClass().getCanonicalName(), factory.getClass().getCanonicalName()));
            }
            return this;
        }

        @Override
        public <T> Iterable<T> instancesExposedAs(Class<T> clazz) {
            Iterable iterable = this.getExposed().get(clazz);
            if (iterable != null) {
                return iterable;
            }
            return Collections.emptyList();
        }

        @Override
        public DefaultInjector setLogger(Consumer<String> consumer) {
            this.logger = consumer;
            return this;
        }

        private class StdOutErrorPrinter
        implements Consumer<String> {
            private StdOutErrorPrinter() {
            }

            @Override
            public void accept(String string) {
                System.out.println(string);
            }
        }
    }
}

