/*
 * Decompiled with CFR 0.152.
 */
package injector.apt;

import generator.apt.SimplifiedAST;
import injector.Mainloop;
import injector.apt.Extensions;
import injector.apt.MainloopMethod;
import java.util.concurrent.atomic.AtomicInteger;

final class MainloopClass {
    private final String jdkGeneratedAnnotation;
    private final String packageName;
    private final String simpleName;
    private final String className;
    private final String method;
    private final int numberOfInstances;
    private final int gracefulShutdownTime;
    private final long intervalWaitTime;

    static Iterable<MainloopClass> from(SimplifiedAST.Type type) {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        return Extensions.convert(MainloopClass.extractMethodName(type), mainloopMethod -> new MainloopClass(type.getJdkGeneratedAnnotation(), type.getPackageName(), type.getSimpleName(), type.getSimpleName() + "MainloopRunner" + atomicInteger.getAndIncrement(), mainloopMethod.getName(), mainloopMethod.numberOfInstances(), mainloopMethod.gracefulShutdownTime(), mainloopMethod.intervalWaitTime()));
    }

    private static Iterable<MainloopMethod> extractMethodName(SimplifiedAST.Type type) {
        return Extensions.convert(Extensions.filter(type.getMethods(), method -> Extensions.first(method.getAnnotations(), annotation -> annotation.getType().equals(Mainloop.class.getCanonicalName())).isPresent()), MainloopMethod::from);
    }

    String getClassCanonicalName() {
        return this.packageName + "." + this.className;
    }

    public MainloopClass(String string, String string2, String string3, String string4, String string5, int n, int n2, long l) {
        this.jdkGeneratedAnnotation = string;
        this.packageName = string2;
        this.simpleName = string3;
        this.className = string4;
        this.method = string5;
        this.numberOfInstances = n;
        this.gracefulShutdownTime = n2;
        this.intervalWaitTime = l;
    }

    public String getJdkGeneratedAnnotation() {
        return this.jdkGeneratedAnnotation;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethod() {
        return this.method;
    }

    public int getNumberOfInstances() {
        return this.numberOfInstances;
    }

    public int getGracefulShutdownTime() {
        return this.gracefulShutdownTime;
    }

    public long getIntervalWaitTime() {
        return this.intervalWaitTime;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MainloopClass)) {
            return false;
        }
        MainloopClass mainloopClass = (MainloopClass)object;
        String string = this.getJdkGeneratedAnnotation();
        String string2 = mainloopClass.getJdkGeneratedAnnotation();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getPackageName();
        String string4 = mainloopClass.getPackageName();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getSimpleName();
        String string6 = mainloopClass.getSimpleName();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.getClassName();
        String string8 = mainloopClass.getClassName();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        String string9 = this.getMethod();
        String string10 = mainloopClass.getMethod();
        if (string9 == null ? string10 != null : !string9.equals(string10)) {
            return false;
        }
        if (this.getNumberOfInstances() != mainloopClass.getNumberOfInstances()) {
            return false;
        }
        if (this.getGracefulShutdownTime() != mainloopClass.getGracefulShutdownTime()) {
            return false;
        }
        return this.getIntervalWaitTime() == mainloopClass.getIntervalWaitTime();
    }

    public int hashCode() {
        int n = 1;
        String string = this.getJdkGeneratedAnnotation();
        n = n * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getPackageName();
        n = n * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getSimpleName();
        n = n * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.getClassName();
        n = n * 59 + (string4 == null ? 43 : string4.hashCode());
        String string5 = this.getMethod();
        n = n * 59 + (string5 == null ? 43 : string5.hashCode());
        n = n * 59 + this.getNumberOfInstances();
        n = n * 59 + this.getGracefulShutdownTime();
        long l = this.getIntervalWaitTime();
        n = n * 59 + (int)(l >>> 32 ^ l);
        return n;
    }

    public String toString() {
        return "MainloopClass(jdkGeneratedAnnotation=" + this.getJdkGeneratedAnnotation() + ", packageName=" + this.getPackageName() + ", simpleName=" + this.getSimpleName() + ", className=" + this.getClassName() + ", method=" + this.getMethod() + ", numberOfInstances=" + this.getNumberOfInstances() + ", gracefulShutdownTime=" + this.getGracefulShutdownTime() + ", intervalWaitTime=" + this.getIntervalWaitTime() + ")";
    }
}

