/*
 * Decompiled with CFR 0.152.
 */
package injector.apt;

import generator.apt.SimplifiedAST;
import injector.Mainloop;
import injector.apt.Extensions;
import java.util.Optional;

final class MainloopMethod {
    private final String name;
    private final Optional<SimplifiedAST.Annotation> annotation;

    int numberOfInstances() {
        SimplifiedAST.Annotation annotation = this.annotation.get();
        String string = annotation.getParameters().getOrDefault("instances", "1").toString();
        return Integer.parseInt(string);
    }

    int gracefulShutdownTime() {
        SimplifiedAST.Annotation annotation = this.annotation.get();
        String string = annotation.getParameters().getOrDefault("gracefulShutdownTime", "120").toString();
        return Integer.parseInt(string);
    }

    long intervalWaitTime() {
        SimplifiedAST.Annotation annotation = this.annotation.get();
        String string = annotation.getParameters().getOrDefault("intervalWaitTime", "1").toString();
        return Long.parseLong(string);
    }

    static MainloopMethod from(SimplifiedAST.Method method) {
        if (!method.getParameters().isEmpty()) {
            throw new RuntimeException("Methods annotated with @Mainloop should have no parameters.");
        }
        return new MainloopMethod(method.getName(), Extensions.first(method.getAnnotations(), annotation -> annotation.getType().equals(Mainloop.class.getCanonicalName())));
    }

    public MainloopMethod(String string, Optional<SimplifiedAST.Annotation> optional) {
        this.name = string;
        this.annotation = optional;
    }

    public String getName() {
        return this.name;
    }

    public Optional<SimplifiedAST.Annotation> getAnnotation() {
        return this.annotation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MainloopMethod)) {
            return false;
        }
        MainloopMethod mainloopMethod = (MainloopMethod)object;
        String string = this.getName();
        String string2 = mainloopMethod.getName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        Optional<SimplifiedAST.Annotation> optional = this.getAnnotation();
        Optional<SimplifiedAST.Annotation> optional2 = mainloopMethod.getAnnotation();
        return !(optional == null ? optional2 != null : !((Object)optional).equals(optional2));
    }

    public int hashCode() {
        int n = 1;
        String string = this.getName();
        n = n * 59 + (string == null ? 43 : string.hashCode());
        Optional<SimplifiedAST.Annotation> optional = this.getAnnotation();
        n = n * 59 + (optional == null ? 43 : ((Object)optional).hashCode());
        return n;
    }

    public String toString() {
        return "MainloopMethod(name=" + this.getName() + ", annotation=" + this.getAnnotation() + ")";
    }
}

