/*
 * Decompiled with CFR 0.152.
 */
package injector.apt;

import generator.apt.SimplifiedAST;
import injector.Exposed;
import injector.ExposedAs;
import injector.New;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

class InjectorType
extends SimplifiedAST.Type {
    List<SimplifiedAST.Method> fixedMethods;
    String exposedClass;
    List<String> exposedInterfaces;

    InjectorType() {
    }

    public boolean isSingleton() {
        return !this.isNew();
    }

    public boolean isNew() {
        return this.getAnnotation(New.class) != null;
    }

    public List<String> getExposedInterfaces() {
        if (this.exposedInterfaces == null) {
            this.exposedInterfaces = new ArrayList<String>();
            SimplifiedAST.Annotation annotation = this.getAnnotation(Exposed.class);
            if (annotation != null) {
                this.exposedInterfaces.addAll(this.loadAllImplementingInterfaces());
            }
        }
        return this.exposedInterfaces;
    }

    private Collection<? extends String> loadAllImplementingInterfaces() {
        return this.getInheritedInterfaces().stream().map(SimplifiedAST.Type::getCanonicalName).collect(Collectors.toList());
    }

    public String getExposedClass() {
        SimplifiedAST.Annotation annotation;
        if (this.exposedClass == null && (annotation = this.getAnnotation(ExposedAs.class)) != null) {
            this.exposedClass = annotation.getValue().toString().replaceAll(".class$", "");
        }
        return this.exposedClass;
    }

    public boolean isAnnotatedWith(Class<? extends Annotation> clazz) {
        return this.getAnnotation(clazz) != null;
    }

    public String toString() {
        String string = String.join((CharSequence)" ", this.getAnnotations().stream().map(annotation -> annotation.toString()).collect(Collectors.toList()));
        return string + ":" + super.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof InjectorType)) {
            return false;
        }
        InjectorType injectorType = (InjectorType)((Object)object);
        if (!injectorType.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        List<SimplifiedAST.Method> list = this.fixedMethods;
        List<SimplifiedAST.Method> list2 = injectorType.fixedMethods;
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        String string = this.getExposedClass();
        String string2 = injectorType.getExposedClass();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        List<String> list3 = this.getExposedInterfaces();
        List<String> list4 = injectorType.getExposedInterfaces();
        return !(list3 == null ? list4 != null : !((Object)list3).equals(list4));
    }

    protected boolean canEqual(Object object) {
        return object instanceof InjectorType;
    }

    public int hashCode() {
        int n = super.hashCode();
        List<SimplifiedAST.Method> list = this.fixedMethods;
        n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
        String string = this.getExposedClass();
        n = n * 59 + (string == null ? 43 : string.hashCode());
        List<String> list2 = this.getExposedInterfaces();
        n = n * 59 + (list2 == null ? 43 : ((Object)list2).hashCode());
        return n;
    }
}

