/*
 * Decompiled with CFR 0.152.
 */
package injector.apt;

import generator.apt.ResourceLocator;
import injector.apt.CustomResourceLocator;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ServiceProviderImplementations {
    static final String EOL = "\n";
    static final String SPI_LOCATION = "META-INF/services/";
    private Map<String, List<String>> spiClasses;
    private CustomResourceLocator resourceLocator;

    ServiceProviderImplementations() {
    }

    void flush() throws IOException {
        for (Map.Entry<String, List<String>> entry : this.spiClasses.entrySet()) {
            this.generateSPIFile(entry.getKey(), entry.getValue());
        }
    }

    void generateSPIFile(String string, List<String> list) throws IOException {
        String string2 = SPI_LOCATION + string;
        Set<String> set = this.resourceLocator.readResourceIfExists(string2);
        set.addAll(list);
        try (Writer writer = this.resourceLocator.createResource(string2);){
            for (String string3 : set) {
                writer.write(string3 + EOL);
            }
        }
    }

    void memorizeImplementationOf(String string2, String string3) {
        this.spiClasses.computeIfAbsent(string2, string -> new ArrayList()).add(string3);
    }

    List<String> getSpiClassesFor(String string2) {
        return this.spiClasses.computeIfAbsent(string2, string -> new ArrayList());
    }

    void cleanCaches() {
        this.spiClasses = new HashMap<String, List<String>>();
    }

    void use(ResourceLocator resourceLocator) {
        this.resourceLocator = new CustomResourceLocator(resourceLocator);
    }
}

