/*
 * Decompiled with CFR 0.152.
 */
package injector.apt;

import generator.apt.SimplifiedAST;
import injector.apt.InjectorMethod;
import injector.apt.InjectorType;
import injector.apt.InjectorTypes;
import injector.apt.utils.DuplicatedConstructorRemover;
import java.util.HashSet;

final class InjectorTypesFactory {
    static InjectorTypes from(SimplifiedAST.Type type) {
        InjectorType injectorType = InjectorTypesFactory.createNewType(type);
        HashSet<InjectorType> hashSet = new HashSet<InjectorType>();
        DuplicatedConstructorRemover.remove(type);
        for (SimplifiedAST.Method method : type.getMethods()) {
            InjectorMethod injectorMethod = InjectorMethod.from(method);
            if (injectorMethod.isProducer()) {
                hashSet.add(InjectorTypesFactory.createTypeWithSingleMethod(type, injectorMethod));
                continue;
            }
            injectorType.getMethods().add(injectorMethod);
        }
        return new InjectorTypes(injectorType, hashSet);
    }

    private static InjectorType createTypeWithSingleMethod(SimplifiedAST.Type type, SimplifiedAST.Method method) {
        InjectorType injectorType = (InjectorType)new InjectorType().setCanonicalName(method.getType()).setType(type.getCanonicalName()).setAnnotations(type.getAnnotations()).setName(type.getName());
        injectorType.getMethods().add(method);
        return injectorType;
    }

    private static InjectorType createNewType(SimplifiedAST.Type type) {
        return (InjectorType)new InjectorType().setCanonicalName(type.getCanonicalName()).setFields(type.getFields()).setType(type.getType()).setAnnotations(type.getAnnotations()).setName(type.getName());
    }

    private InjectorTypesFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

