/*
 * Decompiled with CFR 0.152.
 */
package injector.apt;

import generator.apt.ClassGenerator;
import generator.apt.SimplifiedAST;
import generator.apt.SimplifiedAbstractProcessor;
import injector.Exposed;
import injector.ExposedAs;
import injector.ExposedServicesLoader;
import injector.Factory;
import injector.New;
import injector.Producer;
import injector.Singleton;
import injector.apt.InjectorType;
import injector.apt.InjectorTypes;
import injector.apt.InjectorTypesFactory;
import injector.apt.ServiceProviderImplementations;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"injector.*"})
public class InjectorProcessor
extends SimplifiedAbstractProcessor {
    static final String FACTORY = Factory.class.getCanonicalName();
    static final String LOADER = ExposedServicesLoader.class.getCanonicalName();
    final ClassGenerator nonSingletonFactory = ClassGenerator.with((String)"non-singleton-class-factory.mustache");
    final ClassGenerator singletonFactory = ClassGenerator.with((String)"singleton-class-factory.mustache");
    final ClassGenerator producerClassFactory = ClassGenerator.with((String)"producer-class-factory.mustache");
    final ClassGenerator exposedServiceLoader = ClassGenerator.with((String)"exposed-service-loader.mustache");
    final FactoryClassesGenerator classesGenerator = new FactoryClassesGenerator();
    final ExposedServiceGenerator exposedServiceGenerator = new ExposedServiceGenerator();
    final ServiceProviderImplementations spiClasses = new ServiceProviderImplementations();
    final ServiceProviderImplementations loaderClasses = new ServiceProviderImplementations();
    final JavaFileManager.Location outputLocation;
    Map<String, Object> exposedClasses;

    public InjectorProcessor() {
        this(StandardLocation.CLASS_OUTPUT);
    }

    InjectorProcessor(JavaFileManager.Location location) {
        super(Collections.emptyList(), Collections.singletonList(Producer.class), Arrays.asList(Singleton.class, New.class, ExposedAs.class, Exposed.class));
        this.outputLocation = location;
    }

    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.spiClasses.use(this.resourceLocator);
        this.loaderClasses.use(this.resourceLocator);
    }

    protected void process(Collection<SimplifiedAST.Type> collection) {
        try {
            this.initializeClassCaches();
            this.generateClasses(collection);
            this.spiClasses.flush();
            this.loaderClasses.flush();
        }
        catch (Exception exception) {
            String string = exception.getMessage() != null ? exception.getMessage() : "NullPointerException";
            this.error(string);
            exception.printStackTrace();
        }
    }

    private void initializeClassCaches() {
        this.spiClasses.cleanCaches();
        this.loaderClasses.cleanCaches();
        this.exposedClasses = new HashMap<String, Object>();
    }

    private void generateClasses(Collection<SimplifiedAST.Type> collection) throws IOException {
        for (SimplifiedAST.Type type : collection) {
            InjectorTypes injectorTypes = InjectorTypesFactory.from(type);
            this.classesGenerator.generateRegularFactory(injectorTypes.getRegular());
            this.classesGenerator.generateFactoryForProducers(injectorTypes.getProducers());
            this.exposedServiceGenerator.generate(injectorTypes.getRegular());
        }
    }

    class ExposedServiceGenerator {
        ExposedServiceGenerator() {
        }

        void generate(InjectorType injectorType) throws IOException {
            String string = injectorType.getExposedClass();
            if (string != null) {
                this.generateExposedClassFactory(injectorType, string);
            }
            if (injectorType.isAnnotatedWith(Exposed.class)) {
                List<String> list = injectorType.getExposedInterfaces();
                for (String string2 : list) {
                    this.generateExposedClassFactory(injectorType, string2);
                }
            }
        }

        private void generateExposedClassFactory(InjectorType injectorType, String string) throws IOException {
            String string2 = string + "ExposedServicesLoader";
            String string3 = injectorType.getCanonicalName();
            if (!InjectorProcessor.this.exposedClasses.containsKey(string)) {
                InjectorProcessor.this.info("Generating " + string2);
                this.createSourceFile(injectorType, string2, string);
                InjectorProcessor.this.exposedClasses.put(string, (Object)injectorType);
            }
            InjectorProcessor.this.loaderClasses.memorizeImplementationOf(string, string3);
            InjectorProcessor.this.spiClasses.memorizeImplementationOf(LOADER, string2);
        }

        private void createSourceFile(InjectorType injectorType, String string, String string2) throws IOException {
            try {
                Filer filer = InjectorProcessor.this.processingEnv.getFiler();
                JavaFileObject javaFileObject = filer.createSourceFile(string, new Element[0]);
                try (Writer writer = javaFileObject.openWriter();){
                    injectorType.setCanonicalName(string2);
                    InjectorProcessor.this.exposedServiceLoader.write(writer, (SimplifiedAST.Type)injectorType);
                }
            }
            catch (FilerException filerException) {
                InjectorProcessor.this.warn("Ignoring already created " + injectorType.getCanonicalName());
            }
        }
    }

    class FactoryClassesGenerator {
        FactoryClassesGenerator() {
        }

        void generateRegularFactory(InjectorType injectorType) throws IOException {
            ClassGenerator classGenerator = injectorType.isSingleton() ? InjectorProcessor.this.singletonFactory : InjectorProcessor.this.nonSingletonFactory;
            this.generateFactory(classGenerator, injectorType);
        }

        void generateFactoryForProducers(Collection<InjectorType> collection) throws IOException {
            for (InjectorType injectorType : collection) {
                this.generateFactory(InjectorProcessor.this.producerClassFactory, injectorType);
            }
        }

        private void generateFactory(ClassGenerator classGenerator, InjectorType injectorType) throws IOException {
            String string = injectorType.getCanonicalName() + "InjectorFactory";
            if (!this.factoryHasBeenProcessedBefore(string)) {
                this.createSourceFile(classGenerator, injectorType, string);
                this.memorizeProcessedFactory(string);
            }
        }

        private boolean factoryHasBeenProcessedBefore(String string) {
            return InjectorProcessor.this.spiClasses.getSpiClassesFor(FACTORY).contains(string);
        }

        private void memorizeProcessedFactory(String string) {
            InjectorProcessor.this.spiClasses.getSpiClassesFor(FACTORY).add(string);
        }

        private void createSourceFile(ClassGenerator classGenerator, InjectorType injectorType, String string) throws IOException {
            try {
                Filer filer = InjectorProcessor.this.processingEnv.getFiler();
                JavaFileObject javaFileObject = filer.createSourceFile(string, new Element[0]);
                InjectorProcessor.this.info("Generating " + injectorType.getCanonicalName() + "InjectorFactory (singleton=" + injectorType.isSingleton() + ")");
                try (Writer writer = javaFileObject.openWriter();){
                    classGenerator.write(writer, (SimplifiedAST.Type)injectorType);
                }
            }
            catch (FilerException filerException) {
                InjectorProcessor.this.warn("Ignoring already created " + string);
            }
        }
    }
}

