/*
 * Decompiled with CFR 0.152.
 */
package injector.apt;

import generator.apt.ResourceLocator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Set;

class CustomResourceLocator {
    final ResourceLocator resourceLocator;

    Set<String> readResourceIfExists(String string) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        URI uRI = this.resourceLocator.locate(string);
        File file = new File(uRI);
        if (file.exists()) {
            hashSet.addAll(Files.readAllLines(file.toPath()));
        }
        return hashSet;
    }

    Writer createResource(String string) throws IOException {
        URI uRI = this.resourceLocator.locate(string);
        this.createNeededDirectoriesFor(uRI);
        File file = this.createFile(uRI);
        return new FileWriter(file);
    }

    private void createNeededDirectoriesFor(URI uRI) throws IOException {
        File file = null;
        file = uRI.isAbsolute() ? new File(uRI).getParentFile() : new File(uRI.toString()).getParentFile();
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Could not create dir " + uRI);
        }
    }

    private File createFile(URI uRI) throws IOException {
        File file = new File(uRI);
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Could not create file " + uRI);
        }
        return file;
    }

    public CustomResourceLocator(ResourceLocator resourceLocator) {
        this.resourceLocator = resourceLocator;
    }
}

