/*
 * Decompiled with CFR 0.152.
 */
package injector.apt;

import generator.apt.SimplifiedAbstractProcessor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

public abstract class SPIGeneratorAnnotationProcessor
extends SimplifiedAbstractProcessor {
    static final String EOL = "\n";
    private final JavaFileManager.Location outputLocation = StandardLocation.CLASS_OUTPUT;
    private final String spiLocation;
    private final String spiClass;
    private List<String> spiClasses;

    public SPIGeneratorAnnotationProcessor(Class<?> clazz, List<Class<? extends Annotation>> list, List<Class<? extends Annotation>> list2, List<Class<? extends Annotation>> list3) {
        super(list, list2, list3);
        this.spiClass = clazz.getCanonicalName();
        this.spiLocation = "META-INF/services/" + clazz.getCanonicalName();
    }

    protected void flushSPIClasses() {
        this.spiClasses = new ArrayList<String>();
    }

    protected void memorizeSPIFor(String string) {
        this.spiClasses.add(string);
    }

    protected void generateSPIFiles() throws IOException {
        Set<String> set = this.readResourceIfExists(this.spiLocation);
        set.addAll(this.spiClasses);
        try (Writer writer = this.createResource(this.spiLocation);){
            for (String string : set) {
                this.info("Exposing " + string + " as implementation of " + this.spiClass);
                writer.write(string + EOL);
            }
        }
    }

    private Set<String> readResourceIfExists(String string) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        URI uRI = this.resourceLocator.locate(string);
        File file = new File(uRI);
        if (file.exists()) {
            hashSet.addAll(Files.readAllLines(file.toPath()));
        }
        return hashSet;
    }

    private Writer createResource(String string) throws IOException {
        URI uRI = this.resourceLocator.locate(string);
        this.createNeededDirectoriesTo(uRI);
        File file = this.createFile(uRI);
        return new FileWriter(file);
    }

    private void createNeededDirectoriesTo(URI uRI) throws IOException {
        File file;
        File file2 = file = uRI.isAbsolute() ? new File(uRI).getParentFile() : new File(uRI.toString()).getParentFile();
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Can't create " + file.getAbsolutePath());
        }
    }

    private File createFile(URI uRI) throws IOException {
        File file = new File(uRI);
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Can't create " + file.getAbsolutePath());
        }
        return file;
    }

    public JavaFileManager.Location getOutputLocation() {
        return this.outputLocation;
    }

    public String getSpiLocation() {
        return this.spiLocation;
    }

    public String getSpiClass() {
        return this.spiClass;
    }

    public List<String> getSpiClasses() {
        return this.spiClasses;
    }
}

