/*
 * Decompiled with CFR 0.152.
 */
package injector.apt;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import generator.apt.SimplifiedAST;
import injector.Job;
import injector.Mainloop;
import injector.apt.MainloopClass;
import injector.apt.SPIGeneratorAnnotationProcessor;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.processing.Filer;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"injector.*"})
public class MainloopMethodProcessor
extends SPIGeneratorAnnotationProcessor {
    private static final String ROUTE_CLASS_TEMPLATE = "mainloop-runner-java.mustache";
    private final MustacheFactory mf = new DefaultMustacheFactory();

    public MainloopMethodProcessor() {
        super(Job.class, Collections.emptyList(), Collections.singletonList(Mainloop.class), Collections.emptyList());
    }

    protected void process(Collection<SimplifiedAST.Type> collection) {
        this.flushSPIClasses();
        try {
            for (SimplifiedAST.Type type : collection) {
                this.generateClasses(MainloopClass.from(type));
            }
            this.generateSPIFiles();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void generateClasses(Iterable<MainloopClass> iterable) throws IOException {
        for (MainloopClass mainloopClass : iterable) {
            Filer filer = this.processingEnv.getFiler();
            JavaFileObject javaFileObject = filer.createSourceFile(mainloopClass.getClassCanonicalName(), new Element[0]);
            try (Writer writer = javaFileObject.openWriter();){
                Mustache mustache = this.mf.compile(ROUTE_CLASS_TEMPLATE);
                mustache.execute(writer, (Object)mainloopClass);
            }
            this.memorizeSPIFor(mainloopClass.getClassCanonicalName());
        }
    }
}

