/*
 * Decompiled with CFR 0.152.
 */
package injector.apt;

import generator.apt.ClassGenerator;
import generator.apt.SimplifiedAST;
import generator.apt.SimplifiedAbstractProcessor;
import injector.ExposedServicesLoader;
import injector.Factory;
import injector.New;
import injector.Producer;
import injector.Singleton;
import injector.apt.InjectorMethod;
import injector.apt.InjectorType;
import injector.apt.InjectorTypes;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"javax.inject.*", "injector.*"})
public class InjectorProcessor
extends SimplifiedAbstractProcessor {
    static final String EOL = "\n";
    static final String SPI_LOCATION = "META-INF/services/";
    static final String FACTORY = Factory.class.getCanonicalName();
    static final String FACTORY_LOCATION = "META-INF/services/" + Factory.class.getCanonicalName();
    static final String LOADER = ExposedServicesLoader.class.getCanonicalName();
    static final String LOADER_LOCATION = "META-INF/loader/";
    final ClassGenerator nonSingletonFactory = ClassGenerator.with((String)"non-singleton-class-factory.mustache");
    final ClassGenerator singletonFactory = ClassGenerator.with((String)"singleton-class-factory.mustache");
    final ClassGenerator producerClassFactory = ClassGenerator.with((String)"producer-class-factory.mustache");
    final ClassGenerator exposedServiceLoader = ClassGenerator.with((String)"exposed-service-loader.mustache");
    final JavaFileManager.Location outputLocation;
    Map<String, List<String>> spiClasses;
    Map<String, List<String>> loaderClasses;

    public InjectorProcessor() {
        this(StandardLocation.CLASS_OUTPUT);
    }

    InjectorProcessor(JavaFileManager.Location location) {
        super(Collections.emptyList(), Collections.singletonList(Producer.class), Arrays.asList(Singleton.class, New.class));
        this.outputLocation = location;
    }

    protected void process(Collection<SimplifiedAST.Type> collection) {
        try {
            this.info("Running Dependency Injection Optimization...");
            this.spiClasses = new HashMap<String, List<String>>();
            this.loaderClasses = new HashMap<String, List<String>>();
            this.generateClasses(collection);
            this.generateSPIFiles();
            this.memorizeLoaders();
            this.info("Done!");
        }
        catch (Exception exception) {
            this.error(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void generateClasses(Collection<SimplifiedAST.Type> collection) throws IOException {
        for (SimplifiedAST.Type type : collection) {
            InjectorTypes injectorTypes = this.splitInjectorTypes(type);
            this.generateRegularFactory(injectorTypes.getRegular());
            this.generateProducers(injectorTypes.getProducers());
            this.generateExposedService(injectorTypes.getRegular());
        }
    }

    private InjectorTypes splitInjectorTypes(SimplifiedAST.Type type) {
        InjectorType injectorType = this.createNewType(type);
        ArrayList<InjectorType> arrayList = new ArrayList<InjectorType>();
        for (SimplifiedAST.Method method : type.getMethods()) {
            InjectorMethod injectorMethod = InjectorMethod.from(method);
            if (injectorMethod.isProducer()) {
                arrayList.add(this.createTypeWithSingleMethod(type, injectorMethod));
                continue;
            }
            injectorType.getMethods().add(injectorMethod);
        }
        return new InjectorTypes(injectorType, arrayList);
    }

    private InjectorType createTypeWithSingleMethod(SimplifiedAST.Type type, SimplifiedAST.Method method) {
        InjectorType injectorType = (InjectorType)new InjectorType().setCanonicalName(method.getType()).setType(type.getCanonicalName()).setAnnotations(type.getAnnotations()).setName(type.getName());
        injectorType.getMethods().add(method);
        return injectorType;
    }

    private InjectorType createNewType(SimplifiedAST.Type type) {
        return (InjectorType)new InjectorType().setCanonicalName(type.getCanonicalName()).setFields(type.getFields()).setType(type.getType()).setAnnotations(type.getAnnotations()).setName(type.getName());
    }

    private void generateRegularFactory(InjectorType injectorType) throws IOException {
        ClassGenerator classGenerator = injectorType.isSingleton() ? this.singletonFactory : this.nonSingletonFactory;
        this.generateFactory(classGenerator, injectorType);
    }

    private void generateProducers(List<InjectorType> list) throws IOException {
        for (InjectorType injectorType : list) {
            this.generateFactory(this.producerClassFactory, injectorType);
        }
    }

    private void generateFactory(ClassGenerator classGenerator, InjectorType injectorType) throws IOException {
        String string = injectorType.getCanonicalName() + "Factory";
        if (this.getSpiClassesForFactory().contains(string)) {
            return;
        }
        Filer filer = this.processingEnv.getFiler();
        JavaFileObject javaFileObject = filer.createSourceFile(string, new Element[0]);
        this.info("  + " + injectorType.getCanonicalName() + "Factory (singleton=" + injectorType.isSingleton() + ")");
        try (Writer writer = javaFileObject.openWriter();){
            classGenerator.write(writer, (SimplifiedAST.Type)injectorType);
            this.getSpiClassesForFactory().add(string);
        }
    }

    private void generateSPIFiles() throws IOException {
        for (Map.Entry<String, List<String>> entry : this.spiClasses.entrySet()) {
            String string = SPI_LOCATION + entry.getKey();
            Set<String> set = this.readResourceIfExists(string);
            set.addAll((Collection<String>)entry.getValue());
            Writer writer = this.createResource(string);
            Throwable throwable = null;
            try {
                for (String string2 : set) {
                    writer.write(string2 + EOL);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                writer.close();
            }
        }
    }

    private List<String> getSpiClassesForFactory() {
        return this.spiClasses.computeIfAbsent(FACTORY, string -> new ArrayList());
    }

    private void generateExposedService(InjectorType injectorType) throws IOException {
        String string2 = injectorType.getExposedClass();
        if (string2 != null) {
            string2 = string2.replaceFirst(".class$", "");
            String string3 = injectorType.getCanonicalName() + "ExposedServicesLoader";
            this.info("  + " + string3 + " (getExposedClass=" + string2 + ")");
            Filer filer = this.processingEnv.getFiler();
            JavaFileObject javaFileObject = filer.createSourceFile(string3, new Element[0]);
            try (Writer writer = javaFileObject.openWriter();){
                this.exposedServiceLoader.write(writer, (SimplifiedAST.Type)injectorType);
                this.loaderClasses.computeIfAbsent(string2, string -> new ArrayList()).add(string3);
                this.spiClasses.computeIfAbsent(LOADER, string -> new ArrayList()).add(injectorType.getCanonicalName());
            }
        }
    }

    private void memorizeLoaders() throws IOException {
        for (Map.Entry<String, List<String>> entry : this.loaderClasses.entrySet()) {
            String string = LOADER_LOCATION + entry.getKey();
            Set<String> set = this.readResourceIfExists(string);
            set.addAll((Collection<String>)entry.getValue());
            Writer writer = this.createResource(string);
            Throwable throwable = null;
            try {
                for (String string2 : set) {
                    writer.write(string2 + EOL);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                writer.close();
            }
        }
    }

    private Set<String> readResourceIfExists(String string) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        FileObject fileObject = this.processingEnv.getFiler().getResource(this.outputLocation, "", string);
        File file = new File(fileObject.toUri());
        if (file.exists()) {
            hashSet.addAll(Files.readAllLines(file.toPath()));
        }
        return hashSet;
    }

    private Writer createResource(String string) throws IOException {
        FileObject fileObject = this.processingEnv.getFiler().getResource(this.outputLocation, "", string);
        URI uRI = fileObject.toUri();
        this.createNeededDirectoriesTo(uRI);
        File file = this.createFile(uRI);
        return new FileWriter(file);
    }

    private void createNeededDirectoriesTo(URI uRI) {
        File file = null;
        file = uRI.isAbsolute() ? new File(uRI).getParentFile() : new File(uRI.toString()).getParentFile();
        file.mkdirs();
    }

    private File createFile(URI uRI) throws IOException {
        File file = new File(uRI);
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    private void info(String string) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, string);
    }

    private void error(String string) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, string);
    }
}

