/*
 * Decompiled with CFR 0.152.
 */
package io.sixhours.memcached.cache;

import io.sixhours.memcached.cache.IMemcachedClient;
import io.sixhours.memcached.cache.MemcachedCacheManagerFactory;
import io.sixhours.memcached.cache.MemcachedCacheProperties;
import io.sixhours.memcached.cache.XMemcachedClient;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.MemcachedClientBuilder;
import net.rubyeye.xmemcached.MemcachedSessionLocator;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.aws.AWSElasticCacheClientBuilder;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.command.TextCommandFactory;
import net.rubyeye.xmemcached.impl.ArrayMemcachedSessionLocator;
import net.rubyeye.xmemcached.impl.ElectionMemcachedSessionLocator;
import net.rubyeye.xmemcached.impl.KetamaMemcachedSessionLocator;
import net.rubyeye.xmemcached.impl.LibmemcachedMemcachedSessionLocator;
import net.rubyeye.xmemcached.impl.PHPMemcacheSessionLocator;
import net.rubyeye.xmemcached.impl.RandomMemcachedSessionLocaltor;
import net.rubyeye.xmemcached.impl.RoundRobinMemcachedSessionLocator;

public class XMemcachedCacheManagerFactory
extends MemcachedCacheManagerFactory {
    public XMemcachedCacheManagerFactory(MemcachedCacheProperties properties) {
        super(properties);
    }

    @Override
    IMemcachedClient memcachedClient() throws IOException {
        List<InetSocketAddress> servers = this.properties.getServers();
        MemcachedCacheProperties.Provider provider = this.properties.getProvider();
        MemcachedCacheProperties.Protocol protocol = this.properties.getProtocol();
        MemcachedCacheProperties.HashStrategy hashStrategy = this.properties.getHashStrategy();
        MemcachedClientBuilder builder = this.builder(provider, servers);
        if (builder instanceof AWSElasticCacheClientBuilder) {
            ((AWSElasticCacheClientBuilder)builder).setPollConfigIntervalMs(this.properties.getServersRefreshInterval().toMillis());
        }
        builder.setSessionLocator(this.hashStrategyToLocator(hashStrategy));
        builder.setOpTimeout(this.properties.getOperationTimeout().toMillis());
        builder.setCommandFactory(this.commandFactory(protocol));
        return new XMemcachedClient(builder.build());
    }

    private MemcachedClientBuilder builder(MemcachedCacheProperties.Provider provider, List<InetSocketAddress> servers) {
        switch (provider) {
            case STATIC: {
                return new XMemcachedClientBuilder(servers);
            }
            case AWS: {
                return new AWSElasticCacheClientBuilder(servers);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid provider=%s for the XMemcached configuration", new Object[]{provider}));
    }

    private CommandFactory commandFactory(MemcachedCacheProperties.Protocol protocol) {
        switch (protocol) {
            case TEXT: {
                return new TextCommandFactory();
            }
            case BINARY: {
                return new BinaryCommandFactory();
            }
        }
        throw new IllegalArgumentException("Invalid protocol for the XMemcached configuration");
    }

    private MemcachedSessionLocator hashStrategyToLocator(MemcachedCacheProperties.HashStrategy hashStrategy) {
        switch (hashStrategy) {
            case STANDARD: {
                return new ArrayMemcachedSessionLocator();
            }
            case LIBMEMCACHED: {
                return new LibmemcachedMemcachedSessionLocator();
            }
            case KETAMA: {
                return new KetamaMemcachedSessionLocator();
            }
            case PHP: {
                return new PHPMemcacheSessionLocator();
            }
            case ELECTION: {
                return new ElectionMemcachedSessionLocator();
            }
            case ROUNDROBIN: {
                return new RoundRobinMemcachedSessionLocator();
            }
            case RANDOM: {
                return new RandomMemcachedSessionLocaltor();
            }
        }
        throw new IllegalArgumentException("Invalid hash strategy for the XMemcached configuration");
    }
}

