/*
 * Decompiled with CFR 0.152.
 */
package io.sixhours.memcached.cache;

import io.sixhours.memcached.cache.IMemcachedClient;
import io.sixhours.memcached.cache.MemcachedCacheManagerFactory;
import io.sixhours.memcached.cache.MemcachedCacheProperties;
import io.sixhours.memcached.cache.SpyMemcachedClient;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import net.spy.memcached.ClientMode;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;

public class SpyMemcachedCacheManagerFactory
extends MemcachedCacheManagerFactory {
    public SpyMemcachedCacheManagerFactory(MemcachedCacheProperties properties) {
        super(properties);
    }

    @Override
    IMemcachedClient memcachedClient() throws IOException {
        List<InetSocketAddress> servers = this.properties.getServers();
        MemcachedCacheProperties.Provider provider = this.properties.getProvider();
        MemcachedCacheProperties.Protocol protocol = this.properties.getProtocol();
        MemcachedCacheProperties.HashStrategy hashStrategy = this.properties.getHashStrategy();
        ConnectionFactoryBuilder connectionFactoryBuilder = new ConnectionFactoryBuilder().setLocatorType(this.hashStrategyToLocator(hashStrategy)).setClientMode(this.clientMode(provider)).setOpTimeout(this.properties.getOperationTimeout().toMillis()).setProtocol(this.connectionProtocol(protocol));
        return new SpyMemcachedClient(new MemcachedClient(connectionFactoryBuilder.build(), servers));
    }

    private ClientMode clientMode(MemcachedCacheProperties.Provider provider) {
        switch (provider) {
            case STATIC: {
                return ClientMode.Static;
            }
            case AWS: {
                return ClientMode.Dynamic;
            }
        }
        throw new IllegalArgumentException("Invalid provider for the Spymemcached configuration");
    }

    private ConnectionFactoryBuilder.Protocol connectionProtocol(MemcachedCacheProperties.Protocol protocol) {
        switch (protocol) {
            case TEXT: {
                return ConnectionFactoryBuilder.Protocol.TEXT;
            }
            case BINARY: {
                return ConnectionFactoryBuilder.Protocol.BINARY;
            }
        }
        throw new IllegalArgumentException("Invalid protocol for the Spymemcached configuration");
    }

    private ConnectionFactoryBuilder.Locator hashStrategyToLocator(MemcachedCacheProperties.HashStrategy hashStrategy) {
        switch (hashStrategy) {
            case STANDARD: {
                return ConnectionFactoryBuilder.Locator.ARRAY_MOD;
            }
            case KETAMA: {
                return ConnectionFactoryBuilder.Locator.CONSISTENT;
            }
        }
        throw new IllegalArgumentException("Invalid hash strategy for the Spymemcached configuration");
    }
}

