/*
 * Decompiled with CFR 0.152.
 */
package io.sixhours.memcached.cache;

import io.sixhours.memcached.cache.ConditionalOnMissingRefreshScope;
import io.sixhours.memcached.cache.ConditionalOnRefreshScope;
import io.sixhours.memcached.cache.MemcachedCacheManager;
import io.sixhours.memcached.cache.MemcachedCacheProperties;
import io.sixhours.memcached.cache.NotAppEngineProviderCondition;
import io.sixhours.memcached.cache.SpyMemcachedCacheManagerFactory;
import java.io.IOException;
import net.spy.memcached.MemcachedClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={MemcachedClient.class, CacheManager.class})
@ConditionalOnMissingClass(value={"net.rubyeye.xmemcached.MemcachedClient"})
@Conditional(value={NotAppEngineProviderCondition.class})
@EnableConfigurationProperties(value={MemcachedCacheProperties.class})
public class SpyMemcachedCacheAutoConfiguration {

    @Configuration
    @ConditionalOnMissingRefreshScope
    static class MemcachedCacheConfiguration {
        MemcachedCacheConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={MemcachedCacheManager.class}, search=SearchStrategy.CURRENT)
        public MemcachedCacheManager cacheManager(MemcachedCacheProperties properties) throws IOException {
            return new SpyMemcachedCacheManagerFactory(properties).create();
        }
    }

    @Configuration
    @ConditionalOnRefreshScope
    static class RefreshableMemcachedCacheConfiguration {
        RefreshableMemcachedCacheConfiguration() {
        }

        @Bean
        @RefreshScope
        @ConditionalOnMissingBean(value={MemcachedCacheManager.class}, search=SearchStrategy.CURRENT)
        public MemcachedCacheManager cacheManager(MemcachedCacheProperties properties) throws IOException {
            return new SpyMemcachedCacheManagerFactory(properties).create();
        }
    }
}

