/*
 * Decompiled with CFR 0.152.
 */
package io.sixhours.memcached.cache;

import java.net.InetSocketAddress;

public final class SocketAddress {
    private final InetSocketAddress value;

    public SocketAddress(String value) {
        this.value = this.socketAddress(value);
    }

    public InetSocketAddress value() {
        return this.value;
    }

    private InetSocketAddress socketAddress(String server) {
        if (server == null) {
            throw new IllegalArgumentException("Invalid server value. It should not be null");
        }
        if (server.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid server value. It cannot be empty");
        }
        int finalColon = (server = server.trim()).lastIndexOf(58);
        if (finalColon < 1) {
            throw new IllegalArgumentException("Invalid server value '" + server + "'");
        }
        String hostPart = server.substring(0, finalColon).trim();
        String portNum = server.substring(finalColon + 1).trim();
        return new InetSocketAddress(hostPart, Integer.parseInt(portNum));
    }
}

