/*
 * Decompiled with CFR 0.152.
 */
package io.sixhours.memcached.cache;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import io.sixhours.memcached.cache.MemcachedCache;
import io.sixhours.memcached.cache.XMemcachedClient;

public class MemcachedCacheMetrics
extends CacheMeterBinder {
    private final MemcachedCache cache;

    public MemcachedCacheMetrics(MemcachedCache cache, String cacheName, Iterable<Tag> tags) {
        super((Object)cache, cacheName, tags);
        this.cache = cache;
    }

    protected Long size() {
        return null;
    }

    protected long hitCount() {
        return this.cache.hits();
    }

    protected Long missCount() {
        return this.cache.misses();
    }

    protected Long evictionCount() {
        return this.cache.evictions();
    }

    protected long putCount() {
        return this.cache.puts();
    }

    protected void bindImplementationSpecificMetrics(MeterRegistry registry) {
        if (this.cache.getNativeCache() instanceof XMemcachedClient) {
            XMemcachedClient memcachedClient = (XMemcachedClient)this.cache.getNativeCache();
            registry.gauge("available_servers_count", (Number)memcachedClient.nativeClient().getAvailableServers().size());
        }
    }
}

