/*
 * Decompiled with CFR 0.152.
 */
package io.sixhours.memcached.cache;

import io.sixhours.memcached.cache.IMemcachedClient;
import io.sixhours.memcached.cache.MemcachedCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.springframework.cache.Cache;
import org.springframework.cache.support.NoOpCache;
import org.springframework.cache.transaction.AbstractTransactionSupportingCacheManager;

public class MemcachedCacheManager
extends AbstractTransactionSupportingCacheManager {
    private final Logger logger = Logger.getLogger(MemcachedCacheManager.class.getName());
    final IMemcachedClient memcachedClient;
    private int expiration = 0;
    private String prefix = "memcached:spring-boot";
    private String namespace = "namespace";
    private Map<String, Integer> expirationPerCache;
    private List<String> metricsCacheNames = Collections.emptyList();
    private Set<String> disabledCacheNames = new HashSet<String>();

    public MemcachedCacheManager(IMemcachedClient memcachedClient) {
        this.memcachedClient = memcachedClient;
    }

    protected Collection<? extends Cache> loadCaches() {
        ArrayList<MemcachedCache> caches = new ArrayList<MemcachedCache>();
        for (String metricsCacheName : this.metricsCacheNames) {
            caches.add(this.createCache(metricsCacheName));
        }
        return caches;
    }

    public Cache getCache(String name) {
        if (this.disabledCacheNames.contains(name)) {
            this.logger.info(String.format("Ignoring cache \"%s\" because it is on the disabled cache names", name));
            return new NoOpCache(name);
        }
        return super.getCache(name);
    }

    protected MemcachedCache getMissingCache(String name) {
        return this.createCache(name);
    }

    private MemcachedCache createCache(String name) {
        int cacheExpiration = this.determineExpiration(name);
        return new MemcachedCache(name, this.memcachedClient, cacheExpiration, this.prefix, this.namespace);
    }

    private int determineExpiration(String name) {
        return Optional.ofNullable(this.expirationPerCache).map(e -> (Integer)e.get(name)).orElse(this.expiration);
    }

    public void setExpiration(int expiration) {
        this.expiration = expiration;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setExpirationPerCache(Map<String, Integer> expirationPerCache) {
        this.expirationPerCache = expirationPerCache != null ? new ConcurrentHashMap<String, Integer>(expirationPerCache) : null;
    }

    public void setMetricsCacheNames(List<String> metricsCacheNames) {
        if (metricsCacheNames != null) {
            this.metricsCacheNames = metricsCacheNames;
        }
    }

    public IMemcachedClient client() {
        return this.memcachedClient;
    }

    public void setDisabledCacheNames(Set<String> disabledCacheNames) {
        this.disabledCacheNames = disabledCacheNames;
    }

    public Set<String> getDisabledCacheNames() {
        return this.disabledCacheNames;
    }
}

