/*
 * Decompiled with CFR 0.152.
 */
package io.sixhours.memcached.cache;

import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import io.sixhours.memcached.cache.IMemcachedClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AppEngineMemcachedClient
implements IMemcachedClient {
    private static final Log log = LogFactory.getLog(AppEngineMemcachedClient.class);
    private final MemcacheService service;

    public AppEngineMemcachedClient(MemcacheService service) {
        log.info((Object)"AppEngineMemcachedClient client initialized.");
        this.service = service;
    }

    public MemcacheService nativeClient() {
        return this.service;
    }

    @Override
    public Object get(String key) {
        return this.service.get((Object)key);
    }

    @Override
    public void set(String key, int exp, Object value) {
        this.service.put((Object)key, value, Expiration.byDeltaSeconds((int)exp));
    }

    @Override
    public void touch(String key, int exp) {
        MemcacheService.IdentifiableValue identifiable = this.service.getIdentifiable((Object)key);
        this.service.putIfUntouched((Object)key, identifiable, identifiable.getValue(), Expiration.byDeltaSeconds((int)exp));
    }

    @Override
    public void delete(String key) {
        this.service.delete((Object)key);
    }

    @Override
    public void flush() {
        this.service.clearAll();
    }

    @Override
    public long incr(String key, int by) {
        return this.service.increment((Object)key, (long)by);
    }

    @Override
    public void shutdown() {
    }
}

