/*
 * Decompiled with CFR 0.152.
 */
package io.sixhours.memcached.cache;

import com.google.appengine.api.memcache.BaseMemcacheService;
import io.sixhours.memcached.cache.AppEngineMemcachedCacheManagerFactory;
import io.sixhours.memcached.cache.AppEngineProviderCondition;
import io.sixhours.memcached.cache.ConditionalOnMissingRefreshScope;
import io.sixhours.memcached.cache.ConditionalOnRefreshScope;
import io.sixhours.memcached.cache.MemcachedCacheManager;
import io.sixhours.memcached.cache.MemcachedCacheProperties;
import java.io.IOException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={BaseMemcacheService.class, CacheManager.class})
@Conditional(value={AppEngineProviderCondition.class})
@EnableConfigurationProperties(value={MemcachedCacheProperties.class})
@AutoConfigureAfter(name={"org.springframework.cloud.autoconfigure.RefreshAutoConfiguration"})
public class AppEngineMemcachedCacheAutoConfiguration {

    @Configuration
    @ConditionalOnMissingRefreshScope
    static class MemcachedCacheConfiguration {
        MemcachedCacheConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={MemcachedCacheManager.class}, search=SearchStrategy.CURRENT)
        public MemcachedCacheManager cacheManager(MemcachedCacheProperties properties) throws IOException {
            return new AppEngineMemcachedCacheManagerFactory(properties).create();
        }
    }

    @Configuration
    @ConditionalOnRefreshScope
    static class RefreshableMemcachedCacheConfiguration {
        RefreshableMemcachedCacheConfiguration() {
        }

        @Bean
        @RefreshScope
        @ConditionalOnMissingBean(value={MemcachedCacheManager.class}, search=SearchStrategy.CURRENT)
        public MemcachedCacheManager cacheManager(MemcachedCacheProperties properties) throws IOException {
            return new AppEngineMemcachedCacheManagerFactory(properties).create();
        }
    }
}

