/*
 * Decompiled with CFR 0.152.
 */
package io.sixhours.memcached.cache;

import io.sixhours.memcached.cache.IMemcachedClient;
import io.sixhours.memcached.cache.MemcachedCacheManagerFactory;
import io.sixhours.memcached.cache.MemcachedCacheProperties;
import io.sixhours.memcached.cache.XMemcachedClient;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.aws.AWSElasticCacheClientBuilder;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.command.TextCommandFactory;

public class XMemcachedCacheManagerFactory
extends MemcachedCacheManagerFactory {
    public XMemcachedCacheManagerFactory(MemcachedCacheProperties properties) {
        super(properties);
    }

    @Override
    IMemcachedClient memcachedClient() throws IOException {
        List<InetSocketAddress> servers = this.properties.getServers();
        MemcachedCacheProperties.Provider provider = this.properties.getProvider();
        MemcachedCacheProperties.Protocol protocol = this.properties.getProtocol();
        AWSElasticCacheClientBuilder builder = MemcachedCacheProperties.Provider.AWS.equals((Object)provider) ? new AWSElasticCacheClientBuilder(servers) : new XMemcachedClientBuilder(servers);
        builder.setOpTimeout(this.properties.getOperationTimeout().toMillis());
        builder.setCommandFactory((CommandFactory)(MemcachedCacheProperties.Protocol.BINARY.equals((Object)protocol) ? new BinaryCommandFactory() : new TextCommandFactory()));
        return new XMemcachedClient(builder.build());
    }
}

