/*
 * Decompiled with CFR 0.152.
 */
package io.sixhours.memcached.cache;

import io.sixhours.memcached.cache.Default;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationStyle;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="memcached.cache")
public class MemcachedCacheProperties {
    private List<InetSocketAddress> servers = Default.SERVERS;
    private Provider provider = Default.PROVIDER;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration expiration = Duration.ofSeconds(0L);
    private Map<String, Duration> expirationPerCache = new HashMap<String, Duration>();
    private String prefix = "memcached:spring-boot";
    private Protocol protocol = Default.PROTOCOL;
    private Duration operationTimeout = Duration.ofMillis(2500L);

    public List<InetSocketAddress> getServers() {
        return this.servers;
    }

    public void setServers(String value) {
        if (StringUtils.isEmpty((Object)value)) {
            throw new IllegalArgumentException("Server list is empty");
        }
        this.servers = Stream.of(value.split("\\s*,\\s*")).map(AddrUtil::getOneAddress).collect(Collectors.toList());
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public Duration getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Duration expiration) {
        this.validateExpiration(expiration);
        this.expiration = expiration;
    }

    public void setExpirationPerCache(Map<String, String> expirationPerCache) {
        if (expirationPerCache != null) {
            expirationPerCache.forEach((cacheName, cacheExpiration) -> {
                Duration exp = DurationStyle.detect((String)cacheExpiration).parse(cacheExpiration, ChronoUnit.SECONDS);
                this.validateExpiration(exp);
                this.expirationPerCache.put((String)cacheName, exp);
            });
        }
    }

    public Map<String, Duration> getExpirationPerCache() {
        return this.expirationPerCache;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public Duration getOperationTimeout() {
        return this.operationTimeout;
    }

    public void setOperationTimeout(Duration operationTimeout) {
        if (operationTimeout == Duration.ZERO) {
            throw new IllegalArgumentException("Operation timeout must be greater then zero");
        }
        this.operationTimeout = operationTimeout;
    }

    private void validateExpiration(Duration expiration) {
        if (expiration == null || expiration.toDays() > 30L) {
            throw new IllegalStateException("Invalid expiration. It should not be null or greater than 30 days.");
        }
    }

    public static enum Provider {
        STATIC,
        APPENGINE,
        AWS;

    }

    public static enum Protocol {
        TEXT,
        BINARY;

    }
}

