/*
 * Decompiled with CFR 0.152.
 */
package io.sixhours.memcached.cache;

import io.sixhours.memcached.cache.DisposableMemcachedCacheManager;
import io.sixhours.memcached.cache.IMemcachedClient;
import io.sixhours.memcached.cache.MemcachedCacheManager;
import io.sixhours.memcached.cache.MemcachedCacheProperties;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class MemcachedCacheManagerFactory {
    protected final MemcachedCacheProperties properties;

    public MemcachedCacheManagerFactory(MemcachedCacheProperties properties) {
        this.properties = properties;
    }

    public MemcachedCacheManager create() throws IOException {
        DisposableMemcachedCacheManager cacheManager = new DisposableMemcachedCacheManager(this.memcachedClient());
        cacheManager.setExpiration((int)this.properties.getExpiration().getSeconds());
        cacheManager.setExpirationPerCache(this.properties.getExpirationPerCache().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (int)((Duration)e.getValue()).getSeconds())));
        cacheManager.setPrefix(this.properties.getPrefix());
        cacheManager.setNamespace("namespace");
        return cacheManager;
    }

    abstract IMemcachedClient memcachedClient() throws IOException;
}

