/*
 * Decompiled with CFR 0.152.
 */
package io.sixhours.memcached.cache;

import io.sixhours.memcached.cache.IMemcachedClient;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractValueAdaptingCache;

public class MemcachedCache
extends AbstractValueAdaptingCache {
    private static final String KEY_DELIMITER = ":";
    private final IMemcachedClient memcachedClient;
    private final MemcacheCacheMetadata memcacheCacheMetadata;
    private final Lock lock = new ReentrantLock();
    private final AtomicLong hits = new AtomicLong();
    private final AtomicLong misses = new AtomicLong();
    private final AtomicLong puts = new AtomicLong();
    private final AtomicLong evictions = new AtomicLong();

    public MemcachedCache(String name, IMemcachedClient memcachedClient, int expiration, String prefix, String namespace) {
        super(true);
        this.memcachedClient = memcachedClient;
        this.memcacheCacheMetadata = new MemcacheCacheMetadata(name, expiration, prefix, namespace);
    }

    protected Object lookup(Object key) {
        return this.trackHitsMisses(this.memcachedClient.get(this.memcachedKey(key)));
    }

    public String getName() {
        return this.memcacheCacheMetadata.name();
    }

    public Object getNativeCache() {
        return this.memcachedClient.nativeCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Object key, Callable<T> valueLoader) {
        Object value = this.lookup(key);
        if (value != null) {
            return (T)this.fromStoreValue(value);
        }
        this.lock.lock();
        try {
            value = this.lookup(key);
            if (value != null) {
                Object object = this.fromStoreValue(value);
                return (T)object;
            }
            Object object = this.fromStoreValue(this.loadValue(key, valueLoader));
            return (T)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    private <T> T loadValue(Object key, Callable<T> valueLoader) {
        T value;
        try {
            value = valueLoader.call();
        }
        catch (Exception e) {
            throw new Cache.ValueRetrievalException(key, valueLoader, (Throwable)e);
        }
        this.put(key, value);
        return value;
    }

    public void put(Object key, Object value) {
        this.memcachedClient.set(this.memcachedKey(key), this.memcacheCacheMetadata.expiration(), this.toStoreValue(value));
        this.memcachedClient.touch(this.memcacheCacheMetadata.namespaceKey(), this.memcacheCacheMetadata.expiration());
        this.puts.incrementAndGet();
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Object existingValue = this.lookup(key);
        if (existingValue == null) {
            this.put(key, value);
            return this.toValueWrapper(value);
        }
        return this.toValueWrapper(existingValue);
    }

    public void evict(Object key) {
        this.memcachedClient.delete(this.memcachedKey(key));
        this.evictions.incrementAndGet();
    }

    public void clear() {
        this.memcachedClient.incr(this.memcacheCacheMetadata.namespaceKey(), 1);
    }

    public long hits() {
        return this.hits.get();
    }

    public long misses() {
        return this.misses.get();
    }

    public long puts() {
        return this.puts.get();
    }

    public long evictions() {
        return this.evictions.get();
    }

    private Object trackHitsMisses(Object value) {
        if (value != null) {
            this.hits.incrementAndGet();
        } else {
            this.misses.incrementAndGet();
        }
        return value;
    }

    private String memcachedKey(Object key) {
        return this.memcacheCacheMetadata.keyPrefix() + this.namespaceValue() + KEY_DELIMITER + String.valueOf(key).replaceAll("\\s", "");
    }

    private String namespaceValue() {
        String value = (String)this.memcachedClient.get(this.memcacheCacheMetadata.namespaceKey());
        if (value == null) {
            value = String.valueOf(System.currentTimeMillis());
            this.memcachedClient.set(this.memcacheCacheMetadata.namespaceKey(), this.memcacheCacheMetadata.expiration(), value);
        }
        return value;
    }

    static class MemcacheCacheMetadata {
        private final String name;
        private final int expiration;
        private final String keyPrefix;
        private final String namespaceKey;

        public MemcacheCacheMetadata(String name, int expiration, String cachePrefix, String namespace) {
            this.name = name;
            this.expiration = expiration;
            StringBuilder sb = new StringBuilder(cachePrefix).append(MemcachedCache.KEY_DELIMITER).append(name).append(MemcachedCache.KEY_DELIMITER);
            this.keyPrefix = sb.toString();
            this.namespaceKey = sb.append(namespace).toString();
        }

        public String name() {
            return this.name;
        }

        public int expiration() {
            return this.expiration;
        }

        public String keyPrefix() {
            return this.keyPrefix;
        }

        public String namespaceKey() {
            return this.namespaceKey;
        }
    }
}

