/*
 * Decompiled with CFR 0.152.
 */
package io.sixhours.memcached.cache;

import io.sixhours.memcached.cache.Default;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.ClientMode;
import net.spy.memcached.ConnectionFactoryBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="memcached.cache", ignoreInvalidFields=true)
public class MemcachedCacheProperties {
    private List<InetSocketAddress> servers = Default.SERVERS;
    private ClientMode mode = Default.CLIENT_MODE;
    private Integer expiration = 60;
    private Map<String, Integer> expirations;
    private String prefix = "memcached:spring-boot";
    @Deprecated
    private String namespace = "namespace";
    private Protocol protocol = Default.PROTOCOL;

    public List<InetSocketAddress> getServers() {
        return this.servers;
    }

    public void setServers(String value) {
        if (StringUtils.isEmpty((Object)value)) {
            throw new IllegalArgumentException("Server list is empty");
        }
        this.servers = AddrUtil.getAddresses(Arrays.asList(value.split(",")));
    }

    public ClientMode getMode() {
        return this.mode;
    }

    public void setMode(ClientMode mode) {
        this.mode = mode;
    }

    @DeprecatedConfigurationProperty(reason="As of release {@code 1.3.0}. To be removed in next major release. This value is expected to be extracted from property 'expirations'.", replacement="memcached.cache.expirations")
    public Integer getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Integer expiration) {
        this.expiration = expiration;
    }

    public Map<String, Integer> getExpirations() {
        return this.expirations;
    }

    public void setExpirations(String value) {
        this.expirations = new HashMap<String, Integer>();
        if (StringUtils.isEmpty((Object)value)) {
            throw new IllegalArgumentException("Expiration list is empty");
        }
        String[] expirations = value.split("(?:\\s|,)+");
        Stream.of(expirations).forEach(v -> {
            int colonIndex = v.lastIndexOf(58);
            if (colonIndex < 1) {
                this.expiration = Integer.valueOf(v);
            } else {
                String cacheName = v.substring(0, colonIndex);
                String expiration = v.substring(colonIndex + 1);
                this.expirations.put(cacheName, Integer.valueOf(expiration));
            }
        });
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @DeprecatedConfigurationProperty(reason="As of release {@code 1.1.0}. To be removed in next major release. This value is expected to be retained only as a private value for the cache namespace. The namespace value used is 'namespace'")
    public String getNamespace() {
        if (this.namespace != null) {
            this.namespace = "namespace";
        }
        return this.namespace;
    }

    public void setNamespace(String namespace) {
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public static enum Protocol {
        TEXT,
        BINARY;


        public ConnectionFactoryBuilder.Protocol value() {
            return ConnectionFactoryBuilder.Protocol.valueOf((String)this.name());
        }
    }
}

