/*
 * Decompiled with CFR 0.152.
 */
package io.sixhours.memcached.cache;

import io.sixhours.memcached.cache.DisposableMemcachedCacheManager;
import io.sixhours.memcached.cache.MemcachedCacheManager;
import io.sixhours.memcached.cache.MemcachedCacheProperties;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import net.spy.memcached.ClientMode;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;

public class MemcachedCacheManagerFactory {
    private final MemcachedCacheProperties properties;

    public MemcachedCacheManagerFactory(MemcachedCacheProperties properties) {
        this.properties = properties;
    }

    public MemcachedCacheManager create() throws IOException {
        DisposableMemcachedCacheManager cacheManager = new DisposableMemcachedCacheManager(this.memcachedClient());
        cacheManager.setExpiration(this.properties.getExpiration());
        cacheManager.setExpirations(this.properties.getExpirations());
        cacheManager.setPrefix(this.properties.getPrefix());
        cacheManager.setNamespace(this.properties.getNamespace());
        return cacheManager;
    }

    private MemcachedClient memcachedClient() throws IOException {
        List<InetSocketAddress> servers = this.properties.getServers();
        ClientMode mode = this.properties.getMode();
        MemcachedCacheProperties.Protocol protocol = this.properties.getProtocol();
        ConnectionFactoryBuilder connectionFactoryBuilder = new ConnectionFactoryBuilder().setClientMode(mode).setProtocol(protocol.value());
        return new MemcachedClient(connectionFactoryBuilder.build(), servers);
    }
}

