/*
 * Decompiled with CFR 0.152.
 */
package io.sixhours.memcached.cache;

import io.sixhours.memcached.cache.MemcachedCache;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.spy.memcached.MemcachedClient;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class MemcachedCacheManager
implements CacheManager {
    private final ConcurrentMap<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>();
    final MemcachedClient memcachedClient;
    private int expiration = 60;
    private String prefix = "memcached:spring-boot";
    private String namespace = "namespace";
    private Map<String, Integer> expirations;

    public MemcachedCacheManager(MemcachedClient memcachedClient) {
        this.memcachedClient = memcachedClient;
    }

    public Cache getCache(String name) {
        Cache currentCache;
        Object cache = (Cache)this.cacheMap.get(name);
        if (cache == null && (currentCache = this.cacheMap.putIfAbsent(name, (Cache)(cache = this.createCache(name)))) != null) {
            cache = currentCache;
        }
        return cache;
    }

    public Collection<String> getCacheNames() {
        return Collections.unmodifiableSet(this.cacheMap.keySet());
    }

    private MemcachedCache createCache(String name) {
        int expiration = this.determineExpiration(name);
        return new MemcachedCache(name, this.memcachedClient, expiration, this.prefix, this.namespace);
    }

    private int determineExpiration(String name) {
        Integer expiration = null;
        if (this.expirations != null) {
            expiration = this.expirations.get(name);
        }
        return Optional.ofNullable(expiration).orElse(this.expiration);
    }

    public void setExpiration(int expiration) {
        this.expiration = expiration;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setExpirations(Map<String, Integer> expirations) {
        this.expirations = expirations != null ? new ConcurrentHashMap<String, Integer>(expirations) : null;
    }
}

