/*
 * Decompiled with CFR 0.152.
 */
package io.sixhours.memcached.cache;

import io.sixhours.memcached.cache.ConditionalOnMissingRefreshScope;
import io.sixhours.memcached.cache.ConditionalOnMissingSpringCacheType;
import io.sixhours.memcached.cache.ConditionalOnRefreshScope;
import io.sixhours.memcached.cache.MemcachedCacheManager;
import io.sixhours.memcached.cache.MemcachedCacheManagerFactory;
import io.sixhours.memcached.cache.MemcachedCacheProperties;
import java.io.IOException;
import net.spy.memcached.MemcachedClient;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.CacheAspectSupport;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnMissingSpringCacheType
@ConditionalOnClass(value={MemcachedClient.class, CacheManager.class})
@ConditionalOnBean(value={CacheAspectSupport.class})
@ConditionalOnMissingBean(value={CacheManager.class, CacheResolver.class})
@EnableConfigurationProperties(value={MemcachedCacheProperties.class})
@AutoConfigureBefore(value={CacheAutoConfiguration.class})
@AutoConfigureAfter(name={"org.springframework.cloud.autoconfigure.RefreshAutoConfiguration"})
public class MemcachedCacheAutoConfiguration {

    @Configuration
    @ConditionalOnMissingRefreshScope
    static class MemcachedCacheConfiguration {
        MemcachedCacheConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={MemcachedCacheManager.class}, search=SearchStrategy.CURRENT)
        public MemcachedCacheManager cacheManager(MemcachedCacheProperties properties) throws IOException {
            return new MemcachedCacheManagerFactory(properties).create();
        }
    }

    @Configuration
    @ConditionalOnRefreshScope
    static class RefreshableMemcachedCacheConfiguration {
        RefreshableMemcachedCacheConfiguration() {
        }

        @Bean
        @RefreshScope
        @ConditionalOnMissingBean(value={MemcachedCacheManager.class}, search=SearchStrategy.CURRENT)
        public MemcachedCacheManager cacheManager(MemcachedCacheProperties properties) throws IOException {
            return new MemcachedCacheManagerFactory(properties).create();
        }
    }
}

