/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.cli.parser;

import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.cli.ArgType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0005\u0007\b\t\n\u000bB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/sirix/cli/parser/CliArgType;", "T", "", "Lkotlinx/cli/ArgType;", "hasParameter", "", "(Z)V", "BInteger", "Csv", "Long", "Timestamp", "Uuid", "sirix-kotlin-cli"})
public abstract class CliArgType<T>
extends ArgType<T> {
    public CliArgType(boolean hasParameter) {
        super(hasParameter);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/sirix/cli/parser/CliArgType$Uuid;", "Lorg/sirix/cli/parser/CliArgType;", "Ljava/util/UUID;", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "convert", "value", "name", "sirix-kotlin-cli"})
    public static final class Uuid
    extends CliArgType<UUID> {
        @NotNull
        public static final Uuid INSTANCE = new Uuid();

        private Uuid() {
            super(true);
        }

        @NotNull
        public String getDescription() {
            return "{ xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx }";
        }

        @NotNull
        public UUID convert(@NotNull String value, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            UUID uUID = UUID.fromString(value);
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(value)");
            return uUID;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/sirix/cli/parser/CliArgType$Csv;", "Lkotlinx/cli/ArgType;", "", "", "()V", "description", "getDescription", "()Ljava/lang/String;", "convert", "value", "name", "sirix-kotlin-cli"})
    public static final class Csv
    extends ArgType<List<? extends String>> {
        public Csv() {
            super(true);
        }

        @NotNull
        public String getDescription() {
            return "{ Comma separated List. \"a,b,c\" }";
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<String> convert(@NotNull String value, @NotNull String name) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            String[] stringArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var12_12 = it;
                boolean bl2 = false;
                void v0 = var12_12;
                if (v0 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v0))).toString();
                collection.add(string2);
            }
            return (List)destination$iv$iv;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/sirix/cli/parser/CliArgType$Timestamp;", "Lkotlinx/cli/ArgType;", "Ljava/time/LocalDateTime;", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "convert", "value", "name", "sirix-kotlin-cli"})
    public static final class Timestamp
    extends ArgType<LocalDateTime> {
        public Timestamp() {
            super(true);
        }

        @NotNull
        public String getDescription() {
            return "{ 2020-12-20T18:44:39.464Z }";
        }

        @NotNull
        public LocalDateTime convert(@NotNull String value, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            LocalDateTime localDateTime = LocalDateTime.parse(value);
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"parse(value)");
            return localDateTime;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/sirix/cli/parser/CliArgType$Long;", "Lkotlinx/cli/ArgType;", "", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "convert", "value", "name", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Long;", "sirix-kotlin-cli"})
    public static final class Long
    extends ArgType<java.lang.Long> {
        public Long() {
            super(true);
        }

        @NotNull
        public String getDescription() {
            return "{ Long }";
        }

        @NotNull
        public java.lang.Long convert(@NotNull String value, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            java.lang.Long l = StringsKt.toLongOrNull((String)value);
            if (l == null) {
                throw new IllegalArgumentException("Option " + name + " is expected to be long number. " + value + " is provided.");
            }
            return (long)l;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/sirix/cli/parser/CliArgType$BInteger;", "Lkotlinx/cli/ArgType;", "Ljava/math/BigInteger;", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "convert", "value", "name", "sirix-kotlin-cli"})
    public static final class BInteger
    extends ArgType<BigInteger> {
        public BInteger() {
            super(true);
        }

        @NotNull
        public String getDescription() {
            return "{ -2Integer.MAX_VALUE (exclusive) to +2Integer.MAX_VALUE (exclusive) }";
        }

        @NotNull
        public BigInteger convert(@NotNull String value, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new BigInteger(value);
        }
    }
}

