/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.cli.commands;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.NodeTrx;
import org.sirix.api.ResourceManager;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/sirix/cli/commands/RevisionsHelper;", "", "()V", "Companion", "sirix-kotlin-cli"})
public final class RevisionsHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JU\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\"\f\b\u0000\u0010\u0006*\u00020\u0007*\u00020\b\"\f\b\u0001\u0010\t*\u00020\n*\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\t0\u000f\u00a2\u0006\u0002\u0010\u0010J@\u0010\u0003\u001a\u00020\u0005\"\f\b\u0000\u0010\u0006*\u00020\u0007*\u00020\b\"\f\b\u0001\u0010\t*\u00020\n*\u00020\b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\t0\u000f2\u0006\u0010\u0011\u001a\u00020\rH\u0002JW\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\"\f\b\u0000\u0010\u0006*\u00020\u0007*\u00020\b\"\f\b\u0001\u0010\t*\u00020\n*\u00020\b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\t0\u000f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J}\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\"\f\b\u0000\u0010\u0006*\u00020\u0007*\u00020\b\"\f\b\u0001\u0010\t*\u00020\n*\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\t0\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u001cJ$\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010\u0017\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u001eH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/sirix/cli/commands/RevisionsHelper$Companion;", "", "()V", "getRevisionNumber", "", "", "R", "Lorg/sirix/api/NodeReadOnlyTrx;", "Lorg/sirix/api/NodeCursor;", "W", "Lorg/sirix/api/NodeTrx;", "rev", "revTimestamp", "Ljava/time/LocalDateTime;", "manager", "Lorg/sirix/api/ResourceManager;", "(Ljava/lang/Integer;Ljava/time/LocalDateTime;Lorg/sirix/api/ResourceManager;)[Ljava/lang/Integer;", "revision", "getRevisionNumbers", "revisions", "Lkotlin/Pair;", "(Lorg/sirix/api/ResourceManager;Lkotlin/Pair;)[Ljava/lang/Integer;", "getRevisionsToSerialize", "startRevision", "endRevision", "startRevisionTimestamp", "endRevisionTimestamp", "revisionTimestamp", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/time/LocalDateTime;Ljava/time/LocalDateTime;Lorg/sirix/api/ResourceManager;Ljava/lang/Integer;Ljava/time/LocalDateTime;)[Ljava/lang/Integer;", "parseTimestampRevisions", "", "sirix-kotlin-cli"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor> Integer[] getRevisionsToSerialize(@Nullable Integer startRevision, @Nullable Integer endRevision, @Nullable LocalDateTime startRevisionTimestamp, @Nullable LocalDateTime endRevisionTimestamp, @NotNull ResourceManager<R, W> manager, @Nullable Integer revision, @Nullable LocalDateTime revisionTimestamp) {
            Integer[] integerArray;
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            if (startRevision != null && endRevision != null) {
                Collection $this$toTypedArray$iv = CollectionsKt.toSet((Iterable)((Iterable)new IntRange(startRevision.intValue(), endRevision.intValue())));
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Integer[] integerArray2 = thisCollection$iv.toArray(new Integer[0]);
                if (integerArray2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                integerArray = integerArray2;
            } else if (startRevisionTimestamp != null && endRevisionTimestamp != null) {
                Pair tspRevisions = new Pair((Object)startRevisionTimestamp, (Object)endRevisionTimestamp);
                Collection $this$toTypedArray$iv = ArraysKt.toList((Object[])this.getRevisionNumbers(manager, (Pair<LocalDateTime, LocalDateTime>)tspRevisions));
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Integer[] integerArray3 = thisCollection$iv.toArray(new Integer[0]);
                if (integerArray3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                integerArray = integerArray3;
            } else {
                integerArray = this.getRevisionNumber(revision, revisionTimestamp, manager);
            }
            return integerArray;
        }

        @NotNull
        public final <R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor> Integer[] getRevisionNumber(@Nullable Integer rev, @Nullable LocalDateTime revTimestamp, @NotNull ResourceManager<R, W> manager) {
            Integer[] integerArray;
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            if (rev != null) {
                Integer[] integerArray2 = new Integer[]{(int)rev};
                integerArray = integerArray2;
            } else if (revTimestamp != null) {
                int revision = this.getRevisionNumber(manager, revTimestamp);
                if (revision == 0) {
                    Integer[] integerArray3 = new Integer[]{++revision};
                    integerArray = integerArray3;
                } else {
                    Integer[] integerArray4 = new Integer[]{revision};
                    integerArray = integerArray4;
                }
            } else {
                Integer[] integerArray5 = new Integer[]{manager.getMostRecentRevisionNumber()};
                integerArray = integerArray5;
            }
            return integerArray;
        }

        private final <R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor> int getRevisionNumber(ResourceManager<R, W> manager, LocalDateTime revision) {
            ZonedDateTime zdt = revision.atZone(ZoneId.systemDefault());
            return manager.getRevisionNumber(zdt.toInstant());
        }

        private final <R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor> Integer[] getRevisionNumbers(ResourceManager<R, W> manager, Pair<LocalDateTime, LocalDateTime> revisions) {
            ZonedDateTime zdtFirstRevision = ((LocalDateTime)revisions.getFirst()).atZone(ZoneId.systemDefault());
            ZonedDateTime zdtLastRevision = ((LocalDateTime)revisions.getSecond()).atZone(ZoneId.systemDefault());
            int firstRevisionNumber = manager.getRevisionNumber(zdtFirstRevision.toInstant());
            int lastRevisionNumber = manager.getRevisionNumber(zdtLastRevision.toInstant());
            if (firstRevisionNumber == 0) {
                ++firstRevisionNumber;
            }
            if (lastRevisionNumber == 0) {
                ++lastRevisionNumber;
            }
            Collection $this$toTypedArray$iv = CollectionsKt.toSet((Iterable)((Iterable)new IntRange(firstRevisionNumber, lastRevisionNumber)));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Integer[] integerArray = thisCollection$iv.toArray(new Integer[0]);
            if (integerArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return integerArray;
        }

        private final Pair<LocalDateTime, LocalDateTime> parseTimestampRevisions(String startRevision, String endRevision) {
            LocalDateTime firstRevisionDateTime = LocalDateTime.parse(startRevision);
            LocalDateTime lastRevisionDateTime = LocalDateTime.parse(endRevision);
            return new Pair((Object)firstRevisionDateTime, (Object)lastRevisionDateTime);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

