/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.cli.commands;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sirix.access.User;
import org.sirix.api.Database;
import org.sirix.api.ResourceManager;
import org.sirix.api.RevisionInfo;
import org.sirix.cli.CliOptions;
import org.sirix.cli.commands.CliCommand;
import org.sirix.service.json.serialize.StringValue;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/sirix/cli/commands/DumpResourceHistory;", "Lorg/sirix/cli/commands/CliCommand;", "options", "Lorg/sirix/cli/CliOptions;", "resourceName", "", "user", "Lorg/sirix/access/User;", "(Lorg/sirix/cli/CliOptions;Ljava/lang/String;Lorg/sirix/access/User;)V", "getResourceName", "()Ljava/lang/String;", "execute", "", "sirix-kotlin-cli"})
public final class DumpResourceHistory
extends CliCommand {
    @NotNull
    private final String resourceName;
    @Nullable
    private final User user;

    public DumpResourceHistory(@NotNull CliOptions options, @NotNull String resourceName, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        super(options);
        this.resourceName = resourceName;
        this.user = user;
    }

    @NotNull
    public final String getResourceName() {
        return this.resourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void execute() {
        Database<?> database = this.openDatabase(this.user);
        AutoCloseable autoCloseable = (AutoCloseable)database;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Database it = (Database)autoCloseable;
            boolean bl3 = false;
            StringBuilder buffer = new StringBuilder();
            ResourceManager manager = database.openResourceManager(this.getResourceName());
            AutoCloseable autoCloseable2 = (AutoCloseable)manager;
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                ResourceManager it2 = (ResourceManager)autoCloseable2;
                boolean bl6 = false;
                List historyList = manager.getHistory();
                buffer.append("{\"history\":[");
                Intrinsics.checkNotNullExpressionValue((Object)historyList, (String)"historyList");
                Iterable $this$forEachIndexed$iv = historyList;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void revisionTuple;
                    int n = index$iv++;
                    boolean bl7 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    RevisionInfo revisionInfo = (RevisionInfo)item$iv;
                    int index = n;
                    boolean bl8 = false;
                    buffer.append("{\"revision\":");
                    buffer.append(revisionTuple.getRevision());
                    buffer.append(",");
                    buffer.append("\"revisionTimestamp\":\"");
                    buffer.append(revisionTuple.getRevisionTimestamp());
                    buffer.append("\",");
                    buffer.append("\"author\":\"");
                    buffer.append(StringValue.escape((String)revisionTuple.getUser().getName()));
                    buffer.append("\",");
                    buffer.append("\"commitMessage\":\"");
                    buffer.append(StringValue.escape((String)revisionTuple.getCommitMessage().orElse("")));
                    buffer.append("\"}");
                    if (index == historyList.size() - 1) continue;
                    buffer.append(",");
                }
                StringBuilder stringBuilder = buffer.append("]}");
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            this.getCliPrinter().prnLn(buffer.toString());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }
}

