/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.cli.commands;

import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sirix.access.DatabaseType;
import org.sirix.access.Databases;
import org.sirix.access.User;
import org.sirix.api.Database;
import org.sirix.api.json.JsonResourceManager;
import org.sirix.api.xml.XmlResourceManager;
import org.sirix.cli.CliOptions;
import org.sirix.cli.CliPrinter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0004J\b\u0010\r\u001a\u00020\u000eH&J\u0016\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0004J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0004J\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lorg/sirix/cli/commands/CliCommand;", "", "options", "Lorg/sirix/cli/CliOptions;", "(Lorg/sirix/cli/CliOptions;)V", "cliPrinter", "Lorg/sirix/cli/CliPrinter;", "getCliPrinter", "()Lorg/sirix/cli/CliPrinter;", "getOptions", "()Lorg/sirix/cli/CliOptions;", "databaseType", "Lorg/sirix/access/DatabaseType;", "execute", "", "openDatabase", "Lorg/sirix/api/Database;", "user", "Lorg/sirix/access/User;", "openJsonDatabase", "Lorg/sirix/api/json/JsonResourceManager;", "openXmlDatabase", "Lorg/sirix/api/xml/XmlResourceManager;", "path", "Ljava/nio/file/Path;", "sirix-kotlin-cli"})
public abstract class CliCommand {
    @NotNull
    private final CliOptions options;
    @NotNull
    private final CliPrinter cliPrinter;

    public CliCommand(@NotNull CliOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        this.cliPrinter = new CliPrinter(this.options.getVerbose());
    }

    @NotNull
    protected final CliOptions getOptions() {
        return this.options;
    }

    @NotNull
    protected final CliPrinter getCliPrinter() {
        return this.cliPrinter;
    }

    public abstract void execute();

    @NotNull
    protected final Path path() {
        Path path = Paths.get(this.options.getLocation(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(options.location)");
        return path;
    }

    @NotNull
    protected final DatabaseType databaseType() {
        DatabaseType databaseType = Databases.getDatabaseType((Path)this.path());
        Intrinsics.checkNotNullExpressionValue((Object)databaseType, (String)"getDatabaseType(path())");
        return databaseType;
    }

    @NotNull
    protected final Database<?> openDatabase(@Nullable User user) {
        DatabaseType databaseType = this.databaseType();
        int n = WhenMappings.$EnumSwitchMapping$0[databaseType.ordinal()];
        return switch (n) {
            case 1 -> this.openXmlDatabase(user);
            case 2 -> this.openJsonDatabase(user);
            default -> throw new IllegalStateException("Unknown Database Type!");
        };
    }

    @NotNull
    protected final Database<JsonResourceManager> openJsonDatabase(@Nullable User user) {
        Database database;
        if (user != null) {
            Database database2 = Databases.openJsonDatabase((Path)this.path(), (User)user);
            Intrinsics.checkNotNullExpressionValue((Object)database2, (String)"{\n                openJs\u2026th(), user)\n            }");
            database = database2;
        } else {
            Database database3 = Databases.openJsonDatabase((Path)this.path());
            Intrinsics.checkNotNullExpressionValue((Object)database3, (String)"{\n                openJs\u2026ase(path())\n            }");
            database = database3;
        }
        return database;
    }

    @NotNull
    protected final Database<XmlResourceManager> openXmlDatabase(@Nullable User user) {
        Database database;
        if (user != null) {
            Database database2 = Databases.openXmlDatabase((Path)this.path(), (User)user);
            Intrinsics.checkNotNullExpressionValue((Object)database2, (String)"{\n                openXm\u2026th(), user)\n            }");
            database = database2;
        } else {
            Database database3 = Databases.openXmlDatabase((Path)this.path());
            Intrinsics.checkNotNullExpressionValue((Object)database3, (String)"{\n                openXm\u2026ase(path())\n            }");
            database = database3;
        }
        return database;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DatabaseType.values().length];
            nArray[DatabaseType.XML.ordinal()] = 1;
            nArray[DatabaseType.JSON.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

