/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.cli.commands;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sirix.access.ResourceConfiguration;
import org.sirix.api.Database;
import org.sirix.cli.CliOptions;
import org.sirix.cli.commands.CliCommand;
import org.sirix.cli.commands.DataCommandOptions;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH$J\u0014\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0004J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\nH$R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/sirix/cli/commands/AbstractCreate;", "Lorg/sirix/cli/commands/CliCommand;", "options", "Lorg/sirix/cli/CliOptions;", "dataOptions", "Lorg/sirix/cli/commands/DataCommandOptions;", "(Lorg/sirix/cli/CliOptions;Lorg/sirix/cli/commands/DataCommandOptions;)V", "createDatabase", "", "createOrRemoveAndCreateResource", "", "database", "Lorg/sirix/api/Database;", "execute", "insertData", "sirix-kotlin-cli"})
public abstract class AbstractCreate
extends CliCommand {
    @Nullable
    private final DataCommandOptions dataOptions;

    public AbstractCreate(@NotNull CliOptions options, @Nullable DataCommandOptions dataOptions) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        super(options);
        this.dataOptions = dataOptions;
    }

    protected abstract boolean createDatabase();

    protected abstract void insertData();

    @Override
    public void execute() throws IllegalStateException {
        if (!this.createDatabase()) {
            this.getCliPrinter().prnLnV("Database '" + this.getOptions().getLocation() + "' not created!");
            int n = 1;
            boolean bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        this.getCliPrinter().prnLnV("Database '" + this.getOptions().getLocation() + "' created.");
        if (this.dataOptions != null) {
            this.insertData();
            this.getCliPrinter().prnLnV("Data inserted");
        }
    }

    protected final void createOrRemoveAndCreateResource(@NotNull Database<?> database) {
        Intrinsics.checkNotNullParameter(database, (String)"database");
        DataCommandOptions dataCommandOptions = this.dataOptions;
        Intrinsics.checkNotNull((Object)dataCommandOptions);
        ResourceConfiguration resConfig = new ResourceConfiguration.Builder(dataCommandOptions.getResourceName()).build();
        if (!database.createResource(resConfig)) {
            database.removeResource(this.dataOptions.getResourceName());
            database.createResource(resConfig);
        }
    }
}

