/*
 * Decompiled with CFR 0.152.
 */
package io.sipstack.example.netty.sip.uac;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.pkts.packet.sip.SipMessage;
import io.pkts.packet.sip.SipRequest;
import io.pkts.packet.sip.SipResponse;
import io.pkts.packet.sip.address.SipURI;
import io.pkts.packet.sip.header.CSeqHeader;
import io.pkts.packet.sip.header.CallIdHeader;
import io.pkts.packet.sip.header.ContactHeader;
import io.pkts.packet.sip.header.FromHeader;
import io.pkts.packet.sip.header.ToHeader;
import io.pkts.packet.sip.header.ViaHeader;
import io.sipstack.netty.codec.sip.SipMessageEvent;

@ChannelHandler.Sharable
public final class UACHandler
extends SimpleChannelInboundHandler<SipMessageEvent> {
    private SipRequest generateAck(SipResponse response) {
        ContactHeader contact = response.getContactHeader();
        SipURI requestURI = (SipURI)contact.getAddress().getURI();
        ToHeader to = response.getToHeader();
        FromHeader from = response.getFromHeader();
        CSeqHeader cseq = CSeqHeader.with().cseq(response.getCSeqHeader().getSeqNumber()).method("ACK").build();
        CallIdHeader callId = response.getCallIDHeader();
        ViaHeader via = response.getViaHeader().clone();
        via.setBranch(ViaHeader.generateBranch());
        SipRequest.Builder builder = SipRequest.ack((SipURI)requestURI);
        builder.from(from);
        builder.to(to);
        builder.callId(callId);
        builder.cseq(cseq);
        builder.via(via);
        return builder.build();
    }

    protected void channelRead0(ChannelHandlerContext ctx, SipMessageEvent event) throws Exception {
        SipResponse response;
        SipMessage msg = event.getMessage();
        if (msg.isInvite() && msg.isResponse() && !(response = msg.toResponse()).isRinging() && response.isFinal()) {
            System.err.println("ok, final");
            SipRequest ack = this.generateAck(response);
            System.err.println(ack);
            event.getConnection().send((SipMessage)ack);
        }
        if (msg.isAck()) {
            return;
        }
        if (msg.isRequest()) {
            response = msg.createResponse(200);
            event.getConnection().send((SipMessage)response);
        }
    }
}

