/*
 * Decompiled with CFR 0.152.
 */
package io.sipstack.example.netty.sip.uac;

import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipMessage;
import io.pkts.packet.sip.SipRequest;
import io.pkts.packet.sip.header.FromHeader;
import io.pkts.packet.sip.header.ViaHeader;
import io.sipstack.example.netty.sip.SimpleSipStack;
import io.sipstack.example.netty.sip.uac.UACHandler;
import io.sipstack.netty.codec.sip.Connection;

public final class UAC {
    private final SimpleSipStack stack;
    private final FromHeader from = (FromHeader)FromHeader.with().user("bob").host("example.com").build();

    public UAC(SimpleSipStack stack) {
        this.stack = stack;
    }

    public void send() throws Exception {
        String host = "127.0.0.1";
        int port = 5070;
        Connection connection = this.stack.connect("127.0.0.1", 5070);
        this.from.setParameter(Buffers.wrap((String)"tag"), FromHeader.generateTag());
        ViaHeader via = ViaHeader.with().host("127.0.0.1").port(5070).branch(ViaHeader.generateBranch()).transportUDP().build();
        SipRequest invite = SipRequest.invite((String)"sip:alice@example.com").from(this.from).via(via).build();
        connection.send((SipMessage)invite);
    }

    public static void main(String[] args) throws Exception {
        String ip = "127.0.0.1";
        int port = 5060;
        String transport = "udp";
        UACHandler handler = new UACHandler();
        SimpleSipStack stack = new SimpleSipStack(handler, "127.0.0.1", 5060);
        final UAC uac = new UAC(stack);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                    System.err.println("ok, sending");
                    uac.send();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        stack.run();
    }
}

