/*
 * Decompiled with CFR 0.152.
 */
package io.sipstack.example.netty.sip.registrar;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.pkts.buffer.Buffer;
import io.pkts.packet.sip.SipMessage;
import io.pkts.packet.sip.SipRequest;
import io.pkts.packet.sip.SipResponse;
import io.pkts.packet.sip.address.SipURI;
import io.pkts.packet.sip.address.URI;
import io.pkts.packet.sip.header.ContactHeader;
import io.pkts.packet.sip.header.ExpiresHeader;
import io.pkts.packet.sip.header.SipHeader;
import io.sipstack.example.netty.sip.registrar.Binding;
import io.sipstack.netty.codec.sip.Connection;
import io.sipstack.netty.codec.sip.SipMessageEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class RegistrarHandler
extends SimpleChannelInboundHandler<SipMessageEvent> {
    private final Map<SipURI, List<Binding>> locationStore = new HashMap<SipURI, List<Binding>>();

    protected void channelRead0(ChannelHandlerContext ctx, SipMessageEvent event) throws Exception {
        Connection connection = event.getConnection();
        SipMessage msg = event.getMessage();
        if (msg.isRequest() && msg.isRegister()) {
            SipResponse response = this.processRegisterRequest(msg.toRequest());
            connection.send((SipMessage)response);
        } else if (msg.isRequest() && !msg.isAck()) {
            connection.send((SipMessage)msg.toRequest().createResponse(405));
        }
    }

    private SipResponse processRegisterRequest(SipRequest request) {
        SipURI aor;
        SipURI requestURI = (SipURI)request.getRequestUri();
        Buffer domain = requestURI.getHost();
        if (!this.validateDomain(domain, aor = this.getAOR(request))) {
            return request.createResponse(404);
        }
        Binding.Builder builder = Binding.with();
        builder.aor(aor);
        builder.callId(request.getCallIDHeader());
        builder.expires(this.getExpires(request));
        builder.cseq(request.getCSeqHeader());
        builder.contact(this.getContactURI(request));
        Binding binding = builder.build();
        List<Binding> currentBindings = this.updateBindings(binding);
        SipResponse response = request.createResponse(200);
        currentBindings.forEach(b -> {
            SipURI contactURI = b.getContact();
            contactURI.setParameter("expires", b.getExpires());
            response.addHeader((SipHeader)ContactHeader.with((SipURI)contactURI).build());
        });
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Binding> updateBindings(Binding binding) {
        Map<SipURI, List<Binding>> map = this.locationStore;
        synchronized (map) {
            List<Binding> bindings = this.ensureLocationStore(binding.getAor());
            Iterator<Binding> it = bindings.iterator();
            boolean add = true;
            while (it.hasNext()) {
                Binding bind = it.next();
                if (!bind.getContact().equals((Object)binding.getContact())) continue;
                if (binding.getExpires() == 0) {
                    it.remove();
                    add = false;
                    continue;
                }
                if (!bind.getCallId().equals(binding.getCallId())) {
                    it.remove();
                    continue;
                }
                if (binding.getCseq().getSeqNumber() <= bind.getCseq().getSeqNumber()) continue;
                it.remove();
            }
            if (binding.getExpires() > 0 && add) {
                bindings.add(binding);
            }
            return bindings;
        }
    }

    private List<Binding> ensureLocationStore(SipURI aor) {
        List<Binding> bindings = this.locationStore.get(aor);
        if (bindings == null) {
            bindings = new ArrayList<Binding>();
            this.locationStore.put(aor, bindings);
        }
        return bindings;
    }

    private SipURI getContactURI(SipRequest request) {
        ContactHeader contact = request.getContactHeader();
        URI uri = contact.getAddress().getURI();
        if (uri.isSipURI()) {
            return (SipURI)uri;
        }
        throw new IllegalArgumentException("We only allow SIP URI's in the ContactHeader");
    }

    private boolean validateDomain(Buffer domain, SipURI aor) {
        return aor.getHost().equals((Object)domain);
    }

    private int getExpires(SipRequest request) {
        Buffer value;
        ContactHeader contact = request.getContactHeader();
        if (contact != null && (value = contact.getParameter("expires")) != null) {
            return value.getInt(0);
        }
        ExpiresHeader expires = request.getExpiresHeader();
        return expires.getExpires();
    }

    private SipURI getAOR(SipRequest request) {
        SipURI sipURI = (SipURI)request.getToHeader().getAddress().getURI();
        return SipURI.with().user(sipURI.getUser()).host(sipURI.getHost()).build();
    }
}

