/*
 * Decompiled with CFR 0.152.
 */
package io.sipstack.example.netty.sip.registrar;

import io.pkts.packet.sip.address.SipURI;
import io.pkts.packet.sip.header.CSeqHeader;
import io.pkts.packet.sip.header.CallIdHeader;

public class Binding {
    private final SipURI aor;
    private final int expires;
    private final CSeqHeader cseq;
    private final SipURI contact;
    private final CallIdHeader callId;

    private Binding(SipURI aor, int expires, CSeqHeader cseq, SipURI contact, CallIdHeader callId) {
        this.aor = aor;
        this.expires = expires;
        this.cseq = cseq;
        this.contact = contact.clone();
        this.callId = callId;
    }

    public SipURI getAor() {
        return this.aor;
    }

    public int getExpires() {
        return this.expires;
    }

    public CSeqHeader getCseq() {
        return this.cseq;
    }

    public SipURI getContact() {
        return this.contact.clone();
    }

    public CallIdHeader getCallId() {
        return this.callId;
    }

    public String toString() {
        return this.contact.toString();
    }

    public static Builder with() {
        return new Builder();
    }

    public static class Builder {
        private SipURI aor;
        private int expires;
        private CSeqHeader cseq;
        private SipURI contact;
        private CallIdHeader callId;

        private Builder() {
        }

        public Builder callId(CallIdHeader callId) {
            this.callId = callId;
            return this;
        }

        public Builder aor(SipURI aor) {
            this.aor = aor;
            return this;
        }

        public Builder expires(int expires) {
            this.expires = expires;
            return this;
        }

        public Builder cseq(CSeqHeader cseq) {
            this.cseq = cseq;
            return this;
        }

        public Builder contact(SipURI contact) {
            this.contact = contact;
            return this;
        }

        public Binding build() {
            return new Binding(this.aor, this.expires, this.cseq, this.contact, this.callId);
        }
    }
}

