/*
 * Decompiled with CFR 0.152.
 */
package io.sipstack.example.netty.sip.proxyregistrar;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipMessage;
import io.pkts.packet.sip.SipRequest;
import io.pkts.packet.sip.SipResponse;
import io.pkts.packet.sip.address.SipURI;
import io.pkts.packet.sip.address.URI;
import io.pkts.packet.sip.header.ContactHeader;
import io.pkts.packet.sip.header.ExpiresHeader;
import io.pkts.packet.sip.header.RouteHeader;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.ViaHeader;
import io.sipstack.example.netty.sip.SimpleSipStack;
import io.sipstack.example.netty.sip.proxyregistrar.LocationService;
import io.sipstack.example.netty.sip.registrar.Binding;
import io.sipstack.netty.codec.sip.Connection;
import io.sipstack.netty.codec.sip.SipMessageEvent;
import java.util.List;

public final class ProxyRegistrarHandler
extends SimpleChannelInboundHandler<SipMessageEvent> {
    private final LocationService locationService = LocationService.getInstance();
    private SimpleSipStack stack;

    public void setStack(SimpleSipStack stack) {
        this.stack = stack;
    }

    protected void channelRead0(ChannelHandlerContext ctx, SipMessageEvent event) throws Exception {
        Connection connection = event.getConnection();
        SipMessage msg = event.getMessage();
        if (msg.isRequest() && msg.isOptions()) {
            connection.send((SipMessage)msg.toRequest().createResponse(200));
        } else if (msg.isRequest() && msg.isRegister()) {
            SipResponse response = this.processRegisterRequest(msg.toRequest());
            connection.send((SipMessage)response);
        } else if (msg.isRequest()) {
            SipURI next = this.getNextHop(msg.toRequest());
            if (next != null) {
                this.proxyTo(next, msg.toRequest());
            } else {
                connection.send((SipMessage)msg.toRequest().createResponse(404));
            }
        } else {
            SipResponse response = msg.toResponse();
            response.popViaHeader();
            this.proxy(response);
        }
    }

    private SipURI lookupLocation(SipRequest request) {
        SipURI requestURI = (SipURI)request.getRequestUri();
        SipURI aor = SipURI.with().user(requestURI.getUser()).host(requestURI.getHost()).build();
        List<Binding> bindings = this.locationService.getBindings(aor);
        if (bindings == null || bindings.isEmpty()) {
            return null;
        }
        return bindings.get(0).getContact();
    }

    private SipURI getNextHop(SipRequest request) {
        if (request.isInitial() || request.isAck()) {
            return this.lookupLocation(request);
        }
        RouteHeader route = request.getRouteHeader();
        if (route != null) {
            return (SipURI)route.getAddress().getURI();
        }
        return (SipURI)request.getRequestUri();
    }

    private void proxy(SipResponse msg) {
        ViaHeader via = msg.getViaHeader();
        Connection connection = this.stack.connect(via.getHost(), via.getPort());
        connection.send((SipMessage)msg);
    }

    private void proxyTo(SipURI destination, SipRequest msg) {
        int port = destination.getPort();
        Connection connection = this.stack.connect(destination.getHost(), port == -1 ? 5060 : port);
        Buffer otherBranch = msg.getViaHeader().getBranch();
        Buffer myBranch = Buffers.createBuffer((int)(otherBranch.getReadableBytes() + 4));
        otherBranch.getBytes(myBranch);
        myBranch.write((byte)45);
        myBranch.write((byte)97);
        myBranch.write((byte)98);
        myBranch.write((byte)99);
        ViaHeader via = ViaHeader.with().host("10.0.1.28").port(5060).transportUDP().branch(myBranch).build();
        msg.addHeaderFirst((SipHeader)via);
        try {
            connection.send((SipMessage)msg);
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("this is the message:");
            System.out.println(msg.getRequestUri());
            System.out.println(msg.getMethod());
            System.out.println(msg);
            e.printStackTrace();
        }
    }

    private SipResponse processRegisterRequest(SipRequest request) {
        SipURI aor;
        SipURI requestURI = (SipURI)request.getRequestUri();
        Buffer domain = requestURI.getHost();
        if (!this.validateDomain(domain, aor = this.getAOR(request))) {
            return request.createResponse(404);
        }
        Binding.Builder builder = Binding.with();
        builder.aor(aor);
        builder.callId(request.getCallIDHeader());
        builder.expires(this.getExpires(request));
        builder.cseq(request.getCSeqHeader());
        builder.contact(this.getContactURI(request));
        Binding binding = builder.build();
        List<Binding> currentBindings = this.locationService.updateBindings(binding);
        SipResponse response = request.createResponse(200);
        currentBindings.forEach(b -> {
            SipURI contactURI = b.getContact();
            contactURI.setParameter("expires", b.getExpires());
            ContactHeader contact = (ContactHeader)ContactHeader.with((SipURI)contactURI).build();
            response.addHeader((SipHeader)contact);
        });
        return response;
    }

    private SipURI getContactURI(SipRequest request) {
        ContactHeader contact = request.getContactHeader();
        URI uri = contact.getAddress().getURI();
        if (uri.isSipURI()) {
            return (SipURI)uri;
        }
        throw new IllegalArgumentException("We only allow SIP URI's in the ContactHeader");
    }

    private boolean validateDomain(Buffer domain, SipURI aor) {
        return aor.getHost().equals((Object)domain);
    }

    private int getExpires(SipRequest request) {
        Buffer value;
        ContactHeader contact = request.getContactHeader();
        if (contact != null && (value = contact.getParameter("expires")) != null) {
            return value.getInt(0);
        }
        ExpiresHeader expires = request.getExpiresHeader();
        return expires.getExpires();
    }

    private SipURI getAOR(SipRequest request) {
        SipURI sipURI = (SipURI)request.getToHeader().getAddress().getURI();
        return SipURI.with().user(sipURI.getUser()).host(sipURI.getHost()).build();
    }
}

