/*
 * Decompiled with CFR 0.152.
 */
package io.sipstack.example.netty.sip.proxyregistrar;

import io.pkts.packet.sip.address.SipURI;
import io.sipstack.example.netty.sip.registrar.Binding;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LocationService {
    private final Map<SipURI, List<Binding>> locationStore = new HashMap<SipURI, List<Binding>>();
    private static LocationService me = new LocationService();

    private LocationService() {
    }

    public static LocationService getInstance() {
        return me;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Binding> getBindings(SipURI aor) {
        Map<SipURI, List<Binding>> map = this.locationStore;
        synchronized (map) {
            return this.locationStore.get(aor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Binding> updateBindings(Binding binding) {
        Map<SipURI, List<Binding>> map = this.locationStore;
        synchronized (map) {
            List<Binding> bindings = this.ensureLocationStore(binding.getAor());
            Iterator<Binding> it = bindings.iterator();
            boolean add = true;
            while (it.hasNext()) {
                Binding bind = it.next();
                if (!bind.getContact().equals((Object)binding.getContact())) continue;
                if (binding.getExpires() == 0) {
                    it.remove();
                    add = false;
                    continue;
                }
                if (!bind.getCallId().equals(binding.getCallId())) {
                    it.remove();
                    continue;
                }
                if (binding.getCseq().getSeqNumber() > bind.getCseq().getSeqNumber()) {
                    it.remove();
                    continue;
                }
                add = false;
            }
            if (binding.getExpires() > 0 && add) {
                bindings.add(binding);
            }
            return bindings;
        }
    }

    private List<Binding> ensureLocationStore(SipURI aor) {
        List<Binding> bindings = this.locationStore.get(aor);
        if (bindings == null) {
            bindings = new ArrayList<Binding>();
            this.locationStore.put(aor, bindings);
        }
        return bindings;
    }
}

