/*
 * Decompiled with CFR 0.152.
 */
package io.sipstack.example.netty.sip.proxy;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.pkts.packet.sip.SipMessage;
import io.pkts.packet.sip.SipRequest;
import io.pkts.packet.sip.SipResponse;
import io.pkts.packet.sip.address.SipURI;
import io.pkts.packet.sip.header.RouteHeader;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.ViaHeader;
import io.sipstack.example.netty.sip.SimpleSipStack;
import io.sipstack.netty.codec.sip.Connection;
import io.sipstack.netty.codec.sip.SipMessageEvent;

public final class ProxyHandler
extends SimpleChannelInboundHandler<SipMessageEvent> {
    private SimpleSipStack stack;

    public void setStack(SimpleSipStack stack) {
        this.stack = stack;
    }

    protected void channelRead0(ChannelHandlerContext ctx, SipMessageEvent event) throws Exception {
        SipMessage msg = event.getMessage();
        try {
            if (msg.isRequest()) {
                SipURI next = this.getNextHop(msg.toRequest());
                this.proxyTo(next, msg.toRequest());
            } else {
                SipResponse response = msg.toResponse();
                response.popViaHeader();
                this.proxy(response);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            SipResponse response = msg.toRequest().createResponse(400);
            event.getConnection().send((SipMessage)response);
        }
        catch (Exception e) {
            e.printStackTrace();
            SipResponse response = msg.toRequest().createResponse(500);
            event.getConnection().send((SipMessage)response);
        }
    }

    private void proxy(SipResponse msg) {
        ViaHeader via = msg.getViaHeader();
        Connection connection = this.stack.connect(via.getHost(), via.getPort());
        connection.send((SipMessage)msg);
    }

    private void proxyTo(SipURI destination, SipRequest msg) {
        Connection connection = this.stack.connect(destination.getHost(), destination.getPort());
        ViaHeader via = ViaHeader.with().host("127.0.0.1").port(5060).transportUDP().branch(ViaHeader.generateBranch()).build();
        msg.addHeaderFirst((SipHeader)via);
        connection.send((SipMessage)msg);
    }

    private SipURI getNextHop(SipRequest request) {
        RouteHeader route = request.getRouteHeader();
        if (route != null) {
            return (SipURI)route.getAddress().getURI();
        }
        return (SipURI)request.getRequestUri();
    }
}

