/*
 * Decompiled with CFR 0.152.
 */
package io.sipstack.example.netty.sip;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.pkts.buffer.Buffer;
import io.sipstack.netty.codec.sip.Connection;
import io.sipstack.netty.codec.sip.SipMessageDatagramDecoder;
import io.sipstack.netty.codec.sip.SipMessageEncoder;
import io.sipstack.netty.codec.sip.SipMessageEvent;
import io.sipstack.netty.codec.sip.SipMessageStreamDecoder;
import io.sipstack.netty.codec.sip.UdpConnection;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class SimpleSipStack {
    private final String ip;
    private final int port;
    private final EventLoopGroup bossGroup = new NioEventLoopGroup();
    private final EventLoopGroup workerGroup = new NioEventLoopGroup();
    private final EventLoopGroup udpGroup = new NioEventLoopGroup();
    private final ServerBootstrap serverBootstrap;
    private final Bootstrap bootstrap;
    private Channel udpListeningPoint = null;

    public SimpleSipStack(SimpleChannelInboundHandler<SipMessageEvent> handler, String ip, int port) {
        this.ip = ip;
        this.port = port;
        this.bootstrap = this.createUDPListeningPoint(handler);
        this.serverBootstrap = this.createTCPListeningPoint(handler);
    }

    public Connection connect(String ip, int port) {
        InetSocketAddress remoteAddress = new InetSocketAddress(ip, port);
        return new UdpConnection(this.udpListeningPoint, remoteAddress);
    }

    public Connection connect(Buffer ip, int port) {
        return this.connect(ip.toString(), port);
    }

    public void run() throws Exception {
        try {
            InetSocketAddress socketAddress = new InetSocketAddress(this.ip, this.port);
            this.udpListeningPoint = this.bootstrap.bind((SocketAddress)socketAddress).sync().channel();
            this.serverBootstrap.bind((SocketAddress)socketAddress).sync().channel().closeFuture().await();
        }
        finally {
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
            this.udpGroup.shutdownGracefully();
        }
    }

    private Bootstrap createUDPListeningPoint(final SimpleChannelInboundHandler<SipMessageEvent> handler) {
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)b.group(this.udpGroup)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

            protected void initChannel(DatagramChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new SipMessageDatagramDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new SipMessageEncoder());
                pipeline.addLast("handler", (ChannelHandler)handler);
            }
        });
        return b;
    }

    private ServerBootstrap createTCPListeningPoint(final SimpleChannelInboundHandler<SipMessageEvent> handler) {
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new SipMessageStreamDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new SipMessageEncoder());
                pipeline.addLast("handler", (ChannelHandler)handler);
            }
        }).option(ChannelOption.SO_BACKLOG, (Object)128)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true);
        return b;
    }
}

