/*
 * Decompiled with CFR 0.152.
 */
package io.siniavtsev.jjjson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;

public class JsonSorter {
    private static ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().nodeFactory((JsonNodeFactory)new SortingNodeFactory())).build();

    public static String getSortedJson(String json) throws JsonProcessingException {
        JsonNode root = mapper.reader().readTree(json);
        JsonSorter.recursivelySortArrays(root);
        return mapper.writeValueAsString((Object)root);
    }

    public static void setJsonWriteWithIndent(boolean indent) {
        mapper.configure(SerializationFeature.INDENT_OUTPUT, indent);
    }

    static void recursivelySortArrays(JsonNode jsonRootNode) {
        jsonRootNode.forEach(entry -> {
            if (entry.isArray()) {
                ArrayNode arrayNode = (ArrayNode)entry;
                Iterator i = arrayNode.elements();
                ArrayList<JsonNode> list = new ArrayList<JsonNode>();
                while (i.hasNext()) {
                    list.add((JsonNode)i.next());
                }
                list.sort(Comparator.comparing(JsonNode::toString));
                ((ArrayNode)entry).removeAll().addAll(list);
                entry.forEach(JsonSorter::recursivelySortArrays);
            } else {
                JsonSorter.recursivelySortArrays(entry);
            }
        });
    }

    static class SortingNodeFactory
    extends JsonNodeFactory {
        SortingNodeFactory() {
        }

        public ObjectNode objectNode() {
            return new ObjectNode((JsonNodeFactory)this, new TreeMap());
        }
    }
}

