/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.bctrace.bootstrap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.ByteBuffer;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class BctraceClassLoader
extends ClassLoader {
    private static final String URL_PROTOCOL = "bctrace-agent";
    private final URLStreamHandler handler = new AgentURLStreamHandler();
    private final Map<String, Map<URL, ByteBuffer>> resourceMap = new HashMap<String, Map<URL, ByteBuffer>>();
    private final ProtectionDomain agentProtectionDomain;

    public BctraceClassLoader(String agentJarName) {
        super(null);
        try {
            Permissions permissions = new Permissions();
            permissions.add(new AllPermission());
            this.agentProtectionDomain = new ProtectionDomain(new CodeSource(new URL(URL_PROTOCOL, null, -1, agentJarName, this.handler), (Certificate[])null), permissions, this, null);
            Scanner scanner = new Scanner(ClassLoader.getSystemResourceAsStream("libraries.txt"));
            while (scanner.hasNextLine()) {
                ZipEntry zipEntry;
                String jar = scanner.nextLine();
                URL url = ClassLoader.getSystemResource(jar);
                Manifest mf = BctraceClassLoader.getManifest(new ZipInputStream(url.openStream()));
                if (mf == null) {
                    throw new Error("Library jars used by agent require a manifest. Error found in jar " + jar);
                }
                ZipInputStream zis = new ZipInputStream(url.openStream());
                while ((zipEntry = zis.getNextEntry()) != null) {
                    String name = zipEntry.getName();
                    URL entryURL = new URL(URL_PROTOCOL, null, -1, jar + "!" + name, this.handler);
                    if (name.endsWith("/")) {
                        if (name.startsWith("META-INF/")) continue;
                        try {
                            this.definePackage(name, mf, entryURL);
                            continue;
                        }
                        catch (IllegalArgumentException iae) {
                            if (this.getPackage(name) == null) {
                                throw new AssertionError((Object)("Package " + name + " has already been defined but it could not be found"));
                            }
                            continue;
                        }
                    }
                    byte[] bytes = this.read(zis);
                    Map<URL, ByteBuffer> entryMap = this.resourceMap.get(name);
                    if (entryMap == null) {
                        entryMap = new HashMap<URL, ByteBuffer>();
                        this.resourceMap.put(name, entryMap);
                    }
                    ByteBuffer byteBuffer = ByteBuffer.allocateDirect(bytes.length);
                    byteBuffer.put(bytes);
                    byteBuffer.flip();
                    entryMap.put(entryURL, byteBuffer);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Manifest getManifest(ZipInputStream zis) throws IOException {
        ZipEntry zipEntry;
        while ((zipEntry = zis.getNextEntry()) != null) {
            if (!zipEntry.getName().equals("META-INF/MANIFEST.MF")) continue;
            return new Manifest(zis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Map<URL, ByteBuffer> entryMap = this.resourceMap.get(name.replace('.', '/') + ".class");
        if (entryMap == null) {
            throw new ClassNotFoundException(name);
        }
        ByteBuffer byteBuffer = entryMap.values().iterator().next();
        byte[] bytes = new byte[byteBuffer.limit()];
        ByteBuffer byteBuffer2 = byteBuffer;
        synchronized (byteBuffer2) {
            byteBuffer.position(0);
            byteBuffer.get(bytes);
        }
        return super.defineClass(name, bytes, 0, bytes.length, this.agentProtectionDomain);
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        Map<URL, ByteBuffer> entryMap = this.resourceMap.get(name = BctraceClassLoader.removeLeadingSlash(name));
        if (entryMap == null) {
            return null;
        }
        return Collections.enumeration(entryMap.keySet());
    }

    @Override
    public URL getResource(String name) {
        URL url;
        ClassLoader parent = this.getParent();
        if (parent == null && (url = ClassLoader.getSystemResource(name)) != null) {
            return url;
        }
        return super.getResource(name);
    }

    @Override
    protected URL findResource(String name) {
        Enumeration<URL> urls = this.findResources(name = BctraceClassLoader.removeLeadingSlash(name));
        if (urls == null) {
            return null;
        }
        return urls.nextElement();
    }

    @Override
    protected Package getPackage(String name) {
        return super.getPackage(BctraceClassLoader.getNormalizedPackageName(name));
    }

    private void definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
        if (this.getPackage(name) != null) {
            return;
        }
        String path = name.replace('.', '/').concat("/");
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        String sealed = null;
        URL sealBase = null;
        Attributes attr = man.getAttributes(path);
        if (attr != null) {
            specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if ((attr = man.getMainAttributes()) != null) {
            if (specTitle == null) {
                specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specVersion == null) {
                specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (specVendor == null) {
                specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (implTitle == null) {
                implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implVersion == null) {
                implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (implVendor == null) {
                implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (sealed == null) {
                sealed = attr.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(sealed)) {
            sealBase = url;
        }
        this.definePackage(BctraceClassLoader.getNormalizedPackageName(name), specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    private static String getNormalizedPackageName(String name) {
        return BctraceClassLoader.removeTrailingSlash(name).replace('/', '.');
    }

    private static String removeTrailingSlash(String name) {
        return name.replaceAll("/+$", "");
    }

    private static String removeLeadingSlash(String name) {
        return name.replaceAll("^/+", "");
    }

    private byte[] read(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    private static byte[] toByteArray(InputStream is) throws IOException {
        int r;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((r = is.read(buffer)) != -1) {
            out.write(buffer, 0, r);
        }
        return out.toByteArray();
    }

    private class AgentURLStreamHandler
    extends URLStreamHandler {
        private AgentURLStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            return new AgentURLConnection(url);
        }
    }

    private class AgentURLConnection
    extends URLConnection {
        protected AgentURLConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputStream getInputStream() throws IOException {
            String name = this.url.getFile().substring(this.url.getFile().lastIndexOf("!") + 1);
            Map entryMap = (Map)BctraceClassLoader.this.resourceMap.get(name);
            if (entryMap == null) {
                return null;
            }
            ByteBuffer byteBuffer = (ByteBuffer)entryMap.get(this.url);
            if (byteBuffer == null) {
                return null;
            }
            byte[] bytes = new byte[byteBuffer.limit()];
            ByteBuffer byteBuffer2 = byteBuffer;
            synchronized (byteBuffer2) {
                byteBuffer.position(0);
                byteBuffer.get(bytes);
            }
            return new ByteArrayInputStream(bytes);
        }
    }
}

