/*
 * Decompiled with CFR 0.152.
 */
package io.shick.jsoup.jowli;

import io.shick.jsoup.WhitelistConfiguration;
import io.shick.jsoup.WhitelistConfigurationFormatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class JowliMLFormatter
implements WhitelistConfigurationFormatter {
    private static final Map<String, Character> FACTORY_TO_JOWLI_LETTER;
    public static final char LETTER_BASIC = 'b';
    public static final char LETTER_BASICWITHIMAGES = 'i';
    public static final char LETTER_RELAXED = 'r';
    public static final char LETTER_NONE = 'n';

    public CharSequence format(WhitelistConfiguration configuration) {
        AtomicReference ref = new AtomicReference();
        this.root(Objects.requireNonNull(configuration, "configuration cannot be null"), ref::set);
        return Optional.ofNullable(ref.get()).orElse("");
    }

    private void root(WhitelistConfiguration config, Consumer<CharSequence> c) {
        StringJoiner sj = new StringJoiner(";");
        this.baseDirective(config, sj::add);
        this.tagsDirective(config, sj::add);
        this.allowedAttributesDirective(config, sj::add);
        this.enforcedAttributesDirective(config, sj::add);
        this.protocolsDirective(config, sj::add);
        if (sj.length() > 0) {
            c.accept(sj.toString());
        }
    }

    private void allowedAttributesDirective(WhitelistConfiguration config, Consumer<CharSequence> c) {
        StringJoiner sj = new StringJoiner(",");
        config.allowedAttributes((tag, attrs) -> sj.add(new StringBuilder((String)tag).append(this.bracketed(this.join((List<String>)attrs, ",")))));
        if (sj.length() > 0) {
            c.accept(new StringBuilder("a:").append(sj.toString()));
        }
    }

    private void enforcedAttributesDirective(WhitelistConfiguration config, Consumer<CharSequence> c) {
        StringJoiner sj = new StringJoiner(",");
        config.enforcedAttributes((tag, attrs) -> {
            LinkedList<String> attrValues = new LinkedList<String>();
            attrs.forEach((k, v) -> attrValues.add(this.colonSeparated((String)k, (String)v)));
            sj.add(new StringBuilder((String)tag).append(this.bracketed(this.join(attrValues, ","))));
        });
        if (sj.length() > 0) {
            c.accept(new StringBuilder("e:").append(sj.toString()));
        }
    }

    private void protocolsDirective(WhitelistConfiguration config, Consumer<CharSequence> c) {
        StringJoiner sj = new StringJoiner(",");
        config.allowedProtocols((tag, attrToProtList) -> {
            StringJoiner attrs = new StringJoiner(",");
            attrToProtList.forEach((attr, protlist) -> attrs.add(this.colonSeparated((String)attr, this.bracketed(this.join((List<String>)protlist, ",")))));
            sj.add(new StringBuilder((String)tag).append(this.bracketed(attrs.toString())));
        });
        if (sj.length() > 0) {
            c.accept(new StringBuilder("p:").append(sj.toString()));
        }
    }

    private void tagsDirective(WhitelistConfiguration config, Consumer<CharSequence> c) {
        StringJoiner sj = new StringJoiner(",");
        config.allowedTags(sj::add);
        if (sj.length() > 0) {
            c.accept(new StringBuilder("t:").append(sj.toString()));
        }
    }

    private void baseDirective(WhitelistConfiguration config, Consumer<CharSequence> c) {
        String factory = config.base();
        if (factory != null) {
            c.accept(new StringBuilder("b:").append(FACTORY_TO_JOWLI_LETTER.get(factory)));
        }
    }

    private String join(List<String> attrs, String delimiter) {
        StringJoiner sj = new StringJoiner(delimiter);
        attrs.forEach(sj::add);
        return sj.toString();
    }

    private String bracketed(String string) {
        return "[" + string + "]";
    }

    private String colonSeparated(String s, String s1) {
        return s + ":" + s1;
    }

    static {
        HashMap<String, Character> m = new HashMap<String, Character>();
        m.put("basic", Character.valueOf('b'));
        m.put("basicwithimages", Character.valueOf('i'));
        m.put("relaxed", Character.valueOf('r'));
        m.put("none", Character.valueOf('n'));
        FACTORY_TO_JOWLI_LETTER = m;
    }
}

