/*
 * Decompiled with CFR 0.152.
 */
package io.shick.jsoup.jowli;

import io.shick.jsoup.WhitelistConfiguration;
import io.shick.jsoup.WhitelistConfigurationParser;
import io.shick.jsoup.WhitelistConfigurationParserFactory;
import io.shick.jsoup.jowli.JowliMLWhitelistConfiguration;
import io.shick.jsoup.jowli.ast.AllowedAttributes;
import io.shick.jsoup.jowli.ast.AllowedTags;
import io.shick.jsoup.jowli.ast.Attr;
import io.shick.jsoup.jowli.ast.ConfigConsumer;
import io.shick.jsoup.jowli.ast.EnforcedAttributes;
import io.shick.jsoup.jowli.ast.Prot;
import io.shick.jsoup.jowli.ast.Protocols;
import io.shick.jsoup.jowli.ast.Tag;
import java.text.ParseException;
import java.util.List;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Parsers;
import org.codehaus.jparsec.Scanners;
import org.codehaus.jparsec.error.ParserException;
import org.codehaus.jparsec.functors.Pair;
import org.codehaus.jparsec.functors.Tuples;
import org.codehaus.jparsec.pattern.Pattern;
import org.codehaus.jparsec.pattern.Patterns;

public final class JowliMLParser
implements WhitelistConfigurationParser {
    static final Parser<Void> RIGHT_BRACKET = Scanners.isChar((char)']');
    static final Parser<Void> LEFT_BRACKET = Scanners.isChar((char)'[');
    static final Parser<Void> COMMA = Scanners.isChar((char)',');
    static final Parser<Void> COLON = Scanners.isChar((char)':');
    static final Pattern ALPHA_TOKEN = Patterns.regex((String)"[a-zA-Z]+");
    static final Parser<Prot> PROTOCOL_NAME = ALPHA_TOKEN.toScanner("protocol name").source().map(Prot::new);
    static final Parser<Tag> TAG_NAME = ALPHA_TOKEN.toScanner("tag name").source().map(Tag::new);
    static final Parser<Attr> ATTR_NAME = ALPHA_TOKEN.toScanner("attribute name").source().map(Attr::new);
    static final Parser<String> ENFORCED_VALUE = Patterns.regex((String)"[^\\],]+").toScanner("enforced value").source();
    static final Parser<Pair<Attr, List<Prot>>> ATTR_PROTOCOL_NAMES = Parsers.sequence(ATTR_NAME, COLON, JowliMLParser.bracketed(JowliMLParser.commaed(PROTOCOL_NAME)), (name, __, value) -> Tuples.pair((Object)name, (Object)value));
    static final Parser<Pair<Attr, String>> ATTR_ENFORCED_VALUE = Parsers.sequence(ATTR_NAME, COLON, ENFORCED_VALUE, (name, __, value) -> Tuples.pair((Object)name, (Object)value));
    static final Parser<Pair<Tag, List<Attr>>> TAG_LIST_OF_ATTR_NAMES = Parsers.sequence(TAG_NAME, JowliMLParser.bracketed(JowliMLParser.commaed(ATTR_NAME)), Tuples::pair);
    static final Parser<Pair<Tag, List<Pair<Attr, List<Prot>>>>> TAG_ATTR_PROTOCOLS = Parsers.sequence(TAG_NAME, JowliMLParser.bracketed(JowliMLParser.commaed(ATTR_PROTOCOL_NAMES)), (name, list) -> Tuples.pair((Object)name, (Object)list));
    static final Parser<Pair<Tag, List<Pair<Attr, String>>>> TAG_ATTR_ENFORCED_VALUES = Parsers.sequence(TAG_NAME, JowliMLParser.bracketed(JowliMLParser.commaed(ATTR_ENFORCED_VALUE)), (name, list) -> Tuples.pair((Object)name, (Object)list));
    static final Parser<AllowedTags> ALLOWED_TAGS_DIRECTIVE = Parsers.sequence((Parser)Scanners.isChar((char)'t'), COLON, JowliMLParser.commaed(TAG_NAME), (__, ___, v) -> new AllowedTags((List<Tag>)v));
    static final Parser<AllowedAttributes> ALLOWED_ATTRIBUTES_DIRECTIVE = Parsers.sequence((Parser)Scanners.isChar((char)'a'), COLON, JowliMLParser.commaed(TAG_LIST_OF_ATTR_NAMES), (__, ___, v) -> new AllowedAttributes((List<Pair<Tag, List<Attr>>>)v));
    static final Parser<EnforcedAttributes> ENFORCED_ATTRIBUTES_DIRECTIVE = Parsers.sequence((Parser)Scanners.isChar((char)'e'), COLON, JowliMLParser.commaed(TAG_ATTR_ENFORCED_VALUES), (__, ___, v) -> new EnforcedAttributes((List<Pair<Tag, List<Pair<Attr, String>>>>)v));
    static final Parser<Protocols> PROTOCOLS_DIRECTIVE = Parsers.sequence((Parser)Scanners.isChar((char)'p'), COLON, JowliMLParser.commaed(TAG_ATTR_PROTOCOLS), (__, ___, v) -> new Protocols((List<Pair<Tag, List<Pair<Attr, List<Prot>>>>>)v));
    static final Parser<List<ConfigConsumer>> ROOT = Parsers.or(ALLOWED_ATTRIBUTES_DIRECTIVE, ENFORCED_ATTRIBUTES_DIRECTIVE, PROTOCOLS_DIRECTIVE, ALLOWED_TAGS_DIRECTIVE).sepBy(Scanners.isChar((char)';'));

    static <T> Parser<T> bracketed(Parser<T> parser) {
        return Parsers.between(LEFT_BRACKET, parser, RIGHT_BRACKET);
    }

    static <C> Parser<List<C>> commaed(Parser<C> p) {
        return p.sepBy(COMMA);
    }

    public WhitelistConfiguration parse(CharSequence value) throws ParseException {
        return this.parse(new JowliMLWhitelistConfiguration(), value);
    }

    public WhitelistConfiguration parse(JowliMLWhitelistConfiguration c, CharSequence from) throws ParseException {
        try {
            ((List)ROOT.parse(from)).stream().forEach(consumer -> consumer.accept(c));
            return c;
        }
        catch (ParserException p) {
            throw new ParseException(p.getMessage(), p.getLocation().column);
        }
    }

    static {
        WhitelistConfigurationParserFactory.register((String)"jowli", JowliMLParser::new);
    }
}

