/*
 * Decompiled with CFR 0.152.
 */
package io.shick.jsoup.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.shick.jsoup.WhitelistConfiguration;
import io.shick.jsoup.WhitelistConfigurationFormatter;
import io.shick.jsoup.util.Func;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class GsonFormatter
implements WhitelistConfigurationFormatter {
    public CharSequence format(WhitelistConfiguration configuration) {
        return this.gson().toJson((Object)Objects.requireNonNull(configuration, "configuration cannot be null"));
    }

    Gson gson() {
        return new GsonBuilder().registerTypeHierarchyAdapter(Collection.class, (Object)new CollectionAdapter()).registerTypeHierarchyAdapter(Map.class, (Object)new MapAdapter()).create();
    }

    static class MapAdapter
    implements JsonSerializer<Map<String, ?>> {
        MapAdapter() {
        }

        public JsonElement serialize(Map<String, ?> src, Type typeOfSrc, JsonSerializationContext context) {
            if (Func.empty(src)) {
                return null;
            }
            JsonObject map = new JsonObject();
            src.forEach((k, v) -> {
                JsonElement value = context.serialize(v);
                map.add(k, value);
            });
            return map;
        }
    }

    static class CollectionAdapter
    implements JsonSerializer<Collection<?>> {
        CollectionAdapter() {
        }

        public JsonElement serialize(Collection<?> src, Type typeOfSrc, JsonSerializationContext context) {
            if (Func.empty(src)) {
                return null;
            }
            JsonArray array = new JsonArray();
            src.forEach(value -> array.add(context.serialize(value)));
            return array;
        }
    }
}

