/*
 * Decompiled with CFR 0.152.
 */
package io.shick.jsoup;

import io.shick.jsoup.Func;
import io.shick.jsoup.MutableWhitelistConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jsoup.safety.Whitelist;

abstract class BasicWhitelistConfiguration
implements MutableWhitelistConfiguration {
    private List<String> tags = new ArrayList<String>();
    private Map<String, List<String>> attributes = new HashMap<String, List<String>>();
    private Map<String, Map<String, String>> enforcedAttributes = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, List<String>>> protocols = new HashMap<String, Map<String, List<String>>>();

    BasicWhitelistConfiguration() {
    }

    @Override
    public void allowTag(String tagName) {
        this.tags.add(tagName);
    }

    public boolean allowsTag(String tagName) {
        this.requireTagName(tagName);
        return this.tags != null && this.tags.contains(tagName);
    }

    public boolean hasAllowedAttributes(String tagName) {
        this.requireTagName(tagName);
        return this.attributes != null && this.attributes.containsKey(tagName);
    }

    @Override
    public void allowAttribute(String tagName, String attrName) {
        this.requireTagName(tagName);
        this.requireAttrName(attrName);
        this.attributes.merge(tagName, Func.list(attrName), Func::conj);
    }

    public boolean allowsAttribute(String tagName, String attrName) {
        this.requireAttrName(attrName);
        return this.hasAllowedAttributes(tagName) && this.attributes.get(tagName) != null && this.attributes.get(tagName).contains(attrName);
    }

    public boolean hasEnforcedAttributes(String tagName) {
        this.requireTagName(tagName);
        return this.enforcedAttributes != null && this.enforcedAttributes.containsKey(tagName);
    }

    public boolean enforcesAttribute(String tagName, String attrName) {
        this.requireAttrName(attrName);
        return this.hasEnforcedAttributes(tagName) && this.enforcedAttributes.get(tagName) != null && this.enforcedAttributes.get(tagName).get(attrName) != null;
    }

    public boolean enforcesAttribute(String tagName, String attrName, String enforcedValue) {
        this.requireEnforcedValue(enforcedValue);
        return this.enforcesAttribute(tagName, attrName) && this.enforcedAttributes.get(tagName).get(attrName).equals(enforcedValue);
    }

    @Override
    public void enforceAttribute(String tagName, String attrName, String enforcedValue) {
        this.requireTagName(tagName);
        this.requireAttrName(attrName);
        this.requireEnforcedValue(enforcedValue);
        this.enforcedAttributes.merge(tagName, Func.hashMap(attrName, enforcedValue), Func::merge1);
    }

    public boolean hasAllowedProtocols(String tagName) {
        this.requireTagName(tagName);
        return this.protocols != null && this.protocols.containsKey(tagName);
    }

    public boolean hasAllowedProtocols(String tagName, String attrName) {
        this.requireAttrName(attrName);
        return this.hasAllowedProtocols(tagName) && this.protocols.get(tagName) != null && this.protocols.get(tagName).containsKey(attrName);
    }

    @Override
    public void allowProtocol(String tagName, String attrName, String protocol) {
        this.requireTagName(tagName);
        this.requireAttrName(attrName);
        this.requireProtocol(protocol);
        this.protocols.merge(tagName, Func.hashMap(attrName, Func.list(protocol)), Func::merge2);
    }

    public boolean allowsProtocol(String tagName, String attrName, String protocol) {
        this.requireProtocol(protocol);
        return this.hasAllowedProtocols(tagName, attrName) && this.protocols.get(tagName).get(attrName).contains(protocol);
    }

    private void requireTagName(String tagName) {
        Objects.requireNonNull(tagName, "tagName cannot be null");
    }

    private void requireAttrName(String attrName) {
        Objects.requireNonNull(attrName, "attrName cannot be null");
    }

    private void requireEnforcedValue(String enforcedValueCannot) {
        Objects.requireNonNull(enforcedValueCannot, "enforcedValueCannot be null");
    }

    private void requireProtocol(String protocol) {
        Objects.requireNonNull(protocol, "protocol cannot be null");
    }

    @Override
    public Whitelist apply(Whitelist in) {
        this.applyTags(in);
        this.applyAttributes(in);
        this.applyEnforcedAttributes(in);
        this.applyProtocols(in);
        return in;
    }

    @Override
    public Whitelist whitelist() {
        return this.apply(Whitelist.none());
    }

    private void applyTags(Whitelist in) {
        if (this.tags == null) {
            return;
        }
        in.addTags(this.tags.toArray(new String[this.tags.size()]));
    }

    private void applyAttributes(Whitelist in) {
        if (this.attributes == null) {
            return;
        }
        for (Map.Entry<String, List<String>> attributeEntry : this.attributes.entrySet()) {
            in.addAttributes(attributeEntry.getKey(), attributeEntry.getValue().toArray(new String[attributeEntry.getValue().size()]));
        }
    }

    private void applyEnforcedAttributes(Whitelist in) {
        if (this.enforcedAttributes == null) {
            return;
        }
        for (Map.Entry<String, Map<String, String>> enforcedTag : this.enforcedAttributes.entrySet()) {
            String tag = enforcedTag.getKey();
            for (Map.Entry<String, String> enforcedAttribute : enforcedTag.getValue().entrySet()) {
                String attribute = enforcedAttribute.getKey();
                String value = enforcedAttribute.getValue();
                in.addAttributes(tag, new String[]{attribute});
                in.addEnforcedAttribute(tag, attribute, value);
            }
        }
    }

    private void applyProtocols(Whitelist in) {
        if (this.protocols == null) {
            return;
        }
        for (Map.Entry<String, Map<String, List<String>>> enforcedTag : this.protocols.entrySet()) {
            String tag = enforcedTag.getKey();
            for (Map.Entry<String, List<String>> enforcedAttribute : enforcedTag.getValue().entrySet()) {
                String attribute = enforcedAttribute.getKey();
                List<String> value = enforcedAttribute.getValue();
                in.addAttributes(tag, new String[]{attribute});
                in.addProtocols(tag, attribute, value.toArray(new String[value.size()]));
            }
        }
    }
}

