/*
 * Decompiled with CFR 0.152.
 */
package io.shadowstack;

import io.shadowstack.AdapterException;
import io.shadowstack.Convert;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ArgumentConverter<F, T> {
    public T convert(F var1) throws AdapterException;

    public void convert(F var1, T var2) throws AdapterException;

    public static ArgumentConverter getInstanceFor(Convert convertAnnotation) throws AdapterException {
        Class<ArgumentConverter<?, ?>> useClass = convertAnnotation.use();
        Logger log = LoggerFactory.getLogger(useClass);
        MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
        MethodType mt = MethodType.methodType(ArgumentConverter.class);
        if (!convertAnnotation.factoryMethod().isEmpty()) {
            try {
                MethodHandle instanceHandle = publicLookup.findStatic(useClass, convertAnnotation.factoryMethod(), mt);
                return instanceHandle.invoke();
            }
            catch (Throwable t) {
                String msg = "No invokable static factory method %s() found for class %s.";
                throw new AdapterException(String.format(msg, convertAnnotation.factoryMethod(), useClass.getSimpleName()));
            }
        }
        if (!convertAnnotation.singletonInstance().isEmpty()) {
            try {
                Field f = useClass.getDeclaredField(convertAnnotation.singletonInstance());
                f.setAccessible(true);
                if (f.isAccessible()) {
                    return (ArgumentConverter)f.get(null);
                }
            }
            catch (Throwable t) {
                String msg = "No accessible static member %s() found in class %s.";
                throw new AdapterException(String.format(msg, convertAnnotation.singletonInstance(), useClass.getSimpleName()));
            }
        }
        try {
            MethodHandle instanceHandle = publicLookup.findStatic(useClass, "getInstance", mt);
            return instanceHandle.invoke();
        }
        catch (Throwable t) {
            log.warn("No invokable static factory method getInstance() found for this class.");
            try {
                MethodHandle instanceHandle = publicLookup.findStatic(useClass, "instance", mt);
                return instanceHandle.invoke();
            }
            catch (Throwable t2) {
                log.warn("No invokable static factory method instance() found for this class.");
                try {
                    Field f = useClass.getDeclaredField("INSTANCE");
                    f.setAccessible(true);
                    if (f.isAccessible()) {
                        return (ArgumentConverter)f.get(null);
                    }
                }
                catch (Throwable t3) {
                    log.warn("No accessible static member INSTANCE found for this class.");
                }
                String msg = "Class %s has no static, invokable factory method named 'getInstance' or 'instance', nor does it have an accessible, static member named 'INSTANCE'. No instance of this ArgumentConverter can be obtained.";
                throw new AdapterException(String.format(msg, useClass.getSimpleName()));
            }
        }
    }
}

