/*
 * Decompiled with CFR 0.152.
 */
package io.shadowstack;

import io.shadowstack.AdapterAdvice;
import io.shadowstack.AdapterException;
import io.shadowstack.ArgumentConversion;
import io.shadowstack.ArgumentConverter;
import io.shadowstack.Convert;
import io.shadowstack.Fluently;
import io.shadowstack.MethodRouter;
import io.shadowstack.Mimic;
import io.shadowstack.VoidConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Adapter
implements MethodInterceptor {
    private final Object adaptedInstance;
    private final Map<Method, MethodRouter> methodRouters;

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        MethodRouter router = this.methodRouters.get(method);
        if (router == null) {
            String msg = "No method routing specified for method %s of class %s";
            String cls = this.adaptedInstance.getClass().getSimpleName();
            throw new AdapterException(String.format(msg, method.getName(), cls));
        }
        return router.forward(args, this.adaptedInstance);
    }

    @Generated
    public Object getAdaptedInstance() {
        return this.adaptedInstance;
    }

    @Generated
    public Map<Method, MethodRouter> getMethodRouters() {
        return this.methodRouters;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Adapter)) {
            return false;
        }
        Adapter other = (Adapter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$adaptedInstance = this.getAdaptedInstance();
        Object other$adaptedInstance = other.getAdaptedInstance();
        if (this$adaptedInstance == null ? other$adaptedInstance != null : !this$adaptedInstance.equals(other$adaptedInstance)) {
            return false;
        }
        Map<Method, MethodRouter> this$methodRouters = this.getMethodRouters();
        Map<Method, MethodRouter> other$methodRouters = other.getMethodRouters();
        return !(this$methodRouters == null ? other$methodRouters != null : !((Object)this$methodRouters).equals(other$methodRouters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Adapter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $adaptedInstance = this.getAdaptedInstance();
        result = result * 59 + ($adaptedInstance == null ? 43 : $adaptedInstance.hashCode());
        Map<Method, MethodRouter> $methodRouters = this.getMethodRouters();
        result = result * 59 + ($methodRouters == null ? 43 : ((Object)$methodRouters).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Adapter(adaptedInstance=" + this.getAdaptedInstance() + ", methodRouters=" + this.getMethodRouters() + ")";
    }

    @Generated
    public Adapter(Object adaptedInstance, Map<Method, MethodRouter> methodRouters) {
        this.adaptedInstance = adaptedInstance;
        this.methodRouters = methodRouters;
    }

    public static class InnerBuilder<T> {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(InnerBuilder.class);
        private final Object adaptedInstance;
        private final Class<T> exposedInterface;
        private final Map<Method, MethodRouter> methodRouters = new HashMap<Method, MethodRouter>();

        public InnerBuilder(Object adaptedInstance, Class<T> exposedInterface) {
            this.adaptedInstance = adaptedInstance;
            this.exposedInterface = exposedInterface;
        }

        public InnerBuilder<T> routing(MethodRouter.Builder ... builders) throws AdapterException, NoSuchMethodException {
            if (builders != null && builders.length > 0) {
                for (MethodRouter.Builder builder : builders) {
                    MethodRouter router = builder.build(this.exposedInterface, this.adaptedInstance.getClass());
                    this.methodRouters.put(router.getMethodFrom(), router);
                }
            }
            return this;
        }

        private List<MethodRouter.Builder> deriveMethodRoutersFromAnnotations() throws AdapterException {
            ArrayList<MethodRouter.Builder> methodRouterBuilders = new ArrayList<MethodRouter.Builder>();
            Class<?> adaptedClass = this.adaptedInstance.getClass();
            for (Method adapteeMethod : adaptedClass.getDeclaredMethods()) {
                Class<?> type;
                Mimic mimicAnnotation = adapteeMethod.getAnnotation(Mimic.class);
                if (mimicAnnotation == null) continue;
                Convert convertAnnotation = adapteeMethod.getAnnotation(Convert.class);
                ArgumentConverter<Void, Void> converter = new VoidConverter();
                Class toClass = Void.class;
                if (convertAnnotation != null) {
                    converter = ArgumentConverter.getInstanceFor(convertAnnotation);
                    toClass = convertAnnotation.to();
                }
                if (!(type = mimicAnnotation.type()).equals(this.exposedInterface)) continue;
                MethodRouter.Builder routerBuilder = Fluently.method(adapteeMethod.getName()).to(mimicAnnotation.method());
                ArrayList conversionBuilders = new ArrayList();
                Annotation[][] allParameterAnnotations = adapteeMethod.getParameterAnnotations();
                Class<?>[] parameterTypes = adapteeMethod.getParameterTypes();
                int i = 0;
                for (Annotation[] parameterAnnotations : allParameterAnnotations) {
                    Class<?> parameterClass = parameterTypes[i++];
                    for (Annotation annotation : parameterAnnotations) {
                        if (!(annotation instanceof Convert)) continue;
                        Convert argumentAnnotation = (Convert)annotation;
                        ArgumentConverter ac = ArgumentConverter.getInstanceFor(argumentAnnotation);
                        conversionBuilders.add(Fluently.convert(argumentAnnotation.to()).to(parameterClass).using(ac));
                    }
                }
                routerBuilder.consuming(conversionBuilders.toArray(new ArgumentConversion[0]));
                Class<?> returnType = adapteeMethod.getReturnType();
                routerBuilder.producing(Fluently.convert(returnType).to(toClass).using(converter));
                AdapterAdvice[] advisors = (AdapterAdvice[])adapteeMethod.getAnnotationsByType(AdapterAdvice.class);
                if (advisors != null && advisors.length > 0) {
                    for (AdapterAdvice advice : advisors) {
                        try {
                            switch (advice.pointcut()) {
                                case BEFORE: {
                                    routerBuilder.before(advice.interceptor().getConstructor(new Class[0]).newInstance(new Object[0]));
                                    break;
                                }
                                case AFTER: {
                                    routerBuilder.after(advice.interceptor().getConstructor(new Class[0]).newInstance(new Object[0]));
                                }
                            }
                        }
                        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                            String fullMethodName = adaptedClass.getCanonicalName() + "." + adapteeMethod.getName();
                            String msg = "Couldn't add adapter advice %s to method %s. Is it missing a default constructor?";
                            throw new AdapterException(String.format(msg, advice.interceptor().getSimpleName(), fullMethodName), e);
                        }
                    }
                }
                methodRouterBuilders.add(routerBuilder);
            }
            return methodRouterBuilders;
        }

        public T build() throws AdapterException {
            if (this.adaptedInstance == null) {
                throw new AdapterException("Null adapted instance.");
            }
            if (this.exposedInterface == null) {
                throw new AdapterException("Null target class.");
            }
            if (this.methodRouters.size() == 0) {
                log.info("No method routers provided, attempting to derive from adapted instance annotations...");
                try {
                    List<MethodRouter.Builder> methodRouterBuilders = this.deriveMethodRoutersFromAnnotations();
                    this.routing(methodRouterBuilders.toArray(new MethodRouter.Builder[0]));
                }
                catch (AdapterException e) {
                    throw e;
                }
                catch (NoSuchMethodException e) {
                    throw new AdapterException(e);
                }
            }
            return (T)Enhancer.create(this.exposedInterface, (Callback)new Adapter(this.adaptedInstance, this.methodRouters));
        }
    }

    public static class OuterBuilder {
        private final Object adaptedInstance;

        public <T> InnerBuilder<T> into(Class<T> exposedInterface) {
            return new InnerBuilder<T>(this.adaptedInstance, exposedInterface);
        }

        @Generated
        public OuterBuilder(Object adaptedInstance) {
            this.adaptedInstance = adaptedInstance;
        }
    }
}

