/*
 * Decompiled with CFR 0.152.
 */
package io.shadowstack;

import io.shadowstack.AdapterException;
import io.shadowstack.ArgumentConversion;
import io.shadowstack.MethodForwardingInterceptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.Generated;

public class MethodRouter {
    private final Method methodFrom;
    private final ArgumentConversion<Object, Object>[] consumingFrom;
    private final MethodForwardingInterceptor beforeForwarding;
    private final Method methodTo;
    private final ArgumentConversion<Object, Object> producingTo;
    private final MethodForwardingInterceptor afterForwarding;

    public Object forward(Object[] inputs, Object adaptedInstance) throws AdapterException, InvocationTargetException, IllegalAccessException {
        Object forwardingResult;
        Object forwardingResult2;
        if (inputs == null || adaptedInstance == null) {
            throw new AdapterException("Null inputs or adapted instance.");
        }
        Object currentSourceInput = null;
        Object currentDestinationInput = null;
        int currentSourceInputIndex = -1;
        ArrayList<Object> destinationInputs = new ArrayList<Object>();
        for (ArgumentConversion<Object, Object> conversion : this.consumingFrom) {
            if (currentSourceInput == null || !currentSourceInput.getClass().equals(conversion.getFrom())) {
                currentSourceInput = inputs[++currentSourceInputIndex];
            }
            if (currentDestinationInput == null || !currentDestinationInput.getClass().equals(conversion.getTo())) {
                currentDestinationInput = conversion.convert(currentSourceInput);
                destinationInputs.add(currentDestinationInput);
                continue;
            }
            conversion.convert(currentSourceInput, currentDestinationInput);
        }
        Object[] adaptedInstanceInputs = destinationInputs.toArray();
        if (this.beforeForwarding != null && (forwardingResult2 = this.beforeForwarding.intercept(adaptedInstanceInputs, adaptedInstance, null)) != null) {
            return this.producingTo.convert(forwardingResult2);
        }
        Object adaptedInstanceResult = this.methodTo.invoke(adaptedInstance, adaptedInstanceInputs);
        if (this.afterForwarding != null && (forwardingResult = this.afterForwarding.intercept(adaptedInstanceInputs, adaptedInstance, adaptedInstanceResult)) != null) {
            adaptedInstanceResult = forwardingResult;
        }
        return this.producingTo.convert(adaptedInstanceResult);
    }

    @Generated
    public Method getMethodFrom() {
        return this.methodFrom;
    }

    @Generated
    public ArgumentConversion<Object, Object>[] getConsumingFrom() {
        return this.consumingFrom;
    }

    @Generated
    public MethodForwardingInterceptor getBeforeForwarding() {
        return this.beforeForwarding;
    }

    @Generated
    public Method getMethodTo() {
        return this.methodTo;
    }

    @Generated
    public ArgumentConversion<Object, Object> getProducingTo() {
        return this.producingTo;
    }

    @Generated
    public MethodForwardingInterceptor getAfterForwarding() {
        return this.afterForwarding;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodRouter)) {
            return false;
        }
        MethodRouter other = (MethodRouter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Method this$methodFrom = this.getMethodFrom();
        Method other$methodFrom = other.getMethodFrom();
        if (this$methodFrom == null ? other$methodFrom != null : !((Object)this$methodFrom).equals(other$methodFrom)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getConsumingFrom(), other.getConsumingFrom())) {
            return false;
        }
        MethodForwardingInterceptor this$beforeForwarding = this.getBeforeForwarding();
        MethodForwardingInterceptor other$beforeForwarding = other.getBeforeForwarding();
        if (this$beforeForwarding == null ? other$beforeForwarding != null : !this$beforeForwarding.equals(other$beforeForwarding)) {
            return false;
        }
        Method this$methodTo = this.getMethodTo();
        Method other$methodTo = other.getMethodTo();
        if (this$methodTo == null ? other$methodTo != null : !((Object)this$methodTo).equals(other$methodTo)) {
            return false;
        }
        ArgumentConversion<Object, Object> this$producingTo = this.getProducingTo();
        ArgumentConversion<Object, Object> other$producingTo = other.getProducingTo();
        if (this$producingTo == null ? other$producingTo != null : !((Object)this$producingTo).equals(other$producingTo)) {
            return false;
        }
        MethodForwardingInterceptor this$afterForwarding = this.getAfterForwarding();
        MethodForwardingInterceptor other$afterForwarding = other.getAfterForwarding();
        return !(this$afterForwarding == null ? other$afterForwarding != null : !this$afterForwarding.equals(other$afterForwarding));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MethodRouter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Method $methodFrom = this.getMethodFrom();
        result = result * 59 + ($methodFrom == null ? 43 : ((Object)$methodFrom).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getConsumingFrom());
        MethodForwardingInterceptor $beforeForwarding = this.getBeforeForwarding();
        result = result * 59 + ($beforeForwarding == null ? 43 : $beforeForwarding.hashCode());
        Method $methodTo = this.getMethodTo();
        result = result * 59 + ($methodTo == null ? 43 : ((Object)$methodTo).hashCode());
        ArgumentConversion<Object, Object> $producingTo = this.getProducingTo();
        result = result * 59 + ($producingTo == null ? 43 : ((Object)$producingTo).hashCode());
        MethodForwardingInterceptor $afterForwarding = this.getAfterForwarding();
        result = result * 59 + ($afterForwarding == null ? 43 : $afterForwarding.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MethodRouter(methodFrom=" + this.getMethodFrom() + ", consumingFrom=" + Arrays.deepToString(this.getConsumingFrom()) + ", beforeForwarding=" + this.getBeforeForwarding() + ", methodTo=" + this.getMethodTo() + ", producingTo=" + this.getProducingTo() + ", afterForwarding=" + this.getAfterForwarding() + ")";
    }

    @Generated
    public MethodRouter(Method methodFrom, ArgumentConversion<Object, Object>[] consumingFrom, MethodForwardingInterceptor beforeForwarding, Method methodTo, ArgumentConversion<Object, Object> producingTo, MethodForwardingInterceptor afterForwarding) {
        this.methodFrom = methodFrom;
        this.consumingFrom = consumingFrom;
        this.beforeForwarding = beforeForwarding;
        this.methodTo = methodTo;
        this.producingTo = producingTo;
        this.afterForwarding = afterForwarding;
    }

    public static class DumbBuilder
    extends Builder {
        private final Method methodFrom;
        private Method methodTo;

        public DumbBuilder(Method methodFrom) {
            super(null);
            this.methodFrom = methodFrom;
        }

        public Builder to(Method methodTo) {
            this.methodTo = methodTo;
            return this;
        }

        @Override
        public MethodRouter build(Class<?> classFrom, Class<?> classTo) throws NoSuchMethodException, AdapterException {
            if (this.consumingFrom == null || this.consumingFrom.length == 0) {
                throw new AdapterException("No consuming conversions passed to MethodRouter.Builder.");
            }
            if (this.producingTo == null) {
                throw new AdapterException("Null producing conversion passed to MethodRouter.Builder.");
            }
            if (this.methodTo == null) {
                throw new AdapterException("Empty or null destination method passed to MethodRouter.Builder.");
            }
            if (this.methodFrom == null) {
                throw new AdapterException("Empty or null source method passed to MethodRouter.Builder.");
            }
            return new MethodRouter(this.methodFrom, this.consumingFrom, this.beforeForwarding, this.methodTo, this.producingTo, this.afterForwarding);
        }
    }

    public static class Builder {
        private final String methodFrom;
        private String methodTo;
        protected ArgumentConversion[] consumingFrom;
        protected ArgumentConversion producingTo;
        protected MethodForwardingInterceptor beforeForwarding = null;
        protected MethodForwardingInterceptor afterForwarding = null;

        public Builder(String methodFrom) {
            this.methodFrom = methodFrom;
        }

        public Builder to(String methodTo) {
            this.methodTo = methodTo;
            return this;
        }

        public Builder before(MethodForwardingInterceptor interceptor) {
            this.beforeForwarding = interceptor;
            return this;
        }

        public Builder after(MethodForwardingInterceptor interceptor) {
            this.afterForwarding = interceptor;
            return this;
        }

        public Builder consuming(ArgumentConversion ... conversions) {
            this.consumingFrom = conversions;
            return this;
        }

        public Builder producing(ArgumentConversion conversion) {
            this.producingTo = conversion;
            return this;
        }

        public MethodRouter build(Class<?> classFrom, Class<?> classTo) throws NoSuchMethodException, AdapterException {
            if (this.consumingFrom == null || this.consumingFrom.length == 0) {
                throw new AdapterException("No consuming conversions passed to MethodRouter.Builder.");
            }
            if (this.producingTo == null) {
                throw new AdapterException("Null producing conversion passed to MethodRouter.Builder.");
            }
            if (this.methodTo == null || this.methodTo.isEmpty()) {
                throw new AdapterException("Empty or null destination method passed to MethodRouter.Builder.");
            }
            if (this.methodFrom == null || this.methodFrom.isEmpty()) {
                throw new AdapterException("Empty or null source method passed to MethodRouter.Builder.");
            }
            Class lastIn = null;
            Class lastOut = null;
            ArrayList uniqueIn = new ArrayList();
            ArrayList uniqueOut = new ArrayList();
            for (ArgumentConversion conversion : this.consumingFrom) {
                if (lastIn == null || !lastIn.equals(conversion.getFrom())) {
                    uniqueIn.add(conversion.getFrom());
                    lastIn = conversion.getFrom();
                }
                if (lastOut != null && lastOut.equals(conversion.getTo())) continue;
                uniqueOut.add(conversion.getTo());
                lastOut = conversion.getTo();
            }
            return new MethodRouter(classFrom.getMethod(this.methodFrom, uniqueIn.toArray(new Class[uniqueIn.size()])), this.consumingFrom, this.beforeForwarding, classTo.getMethod(this.methodTo, uniqueOut.toArray(new Class[uniqueOut.size()])), this.producingTo, this.afterForwarding);
        }
    }
}

